/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.maven.sandbox.ThreadPermissionVerifier;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class PrivilegedThreads {
    private static volatile ThreadPermissionVerifier defaultPermissionVerfier;
    private static AtomicReference<Map<Thread, ThreadPermissionVerifier>> permissionVerifiers;

    private PrivilegedThreads() {
    }

    static ThreadPermissionVerifier getThreadPermissionChecker() {
        ThreadPermissionVerifier threadPermissionVerifier = permissionVerifiers.get().get(Thread.currentThread());
        return threadPermissionVerifier != null ? threadPermissionVerifier : defaultPermissionVerfier;
    }

    static void setThreadPermissionCheckers(Map<Thread, ThreadPermissionVerifier> verifiers, ThreadPermissionVerifier defaultPermissionVerifier) {
        if (!permissionVerifiers.compareAndSet(null, verifiers)) {
            throw new IllegalStateException("Cannot nest secure method invocations");
        }
        defaultPermissionVerfier = defaultPermissionVerifier;
    }

    @VisibleForTesting
    public static void resetThreadPermissionCheckers() {
        PrivilegedThreads.getThreadPermissionChecker().checkPermission(new RuntimePermission("setSecurityManager"));
        defaultPermissionVerfier = null;
        permissionVerifiers.set(null);
    }

    static {
        permissionVerifiers = new AtomicReference();
    }
}

