/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.maven.sandbox.BambooSpecsSecurityManager;
import com.atlassian.bamboo.specs.maven.sandbox.ThreadPermissionVerifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class SecureMethodInvoker {
    private SecureMethodInvoker() {
    }

    public static void startPerThreadSecurity(Map<Thread, ThreadPermissionVerifier> specializedVerifiers, ThreadPermissionVerifier defaultPermissionVerifier) {
        BambooSpecsSecurityManager.setPermissionCheckers(specializedVerifiers, defaultPermissionVerifier);
    }

    public static <T> T invoke(Supplier<T> hostileCode) {
        return SecureMethodInvoker.invokeInternal(hostileCode);
    }

    private static <T> T invokeInternal(Supplier<T> hostileCode) {
        AtomicReference<RuntimeException> exceptionRef = new AtomicReference<RuntimeException>();
        AtomicReference<Error> errorRef = new AtomicReference<Error>();
        AtomicReference result = new AtomicReference();
        Runnable runnable = () -> {
            try {
                System.setSecurityManager(new BambooSpecsSecurityManager());
                result.set(hostileCode.get());
            }
            catch (RuntimeException e) {
                exceptionRef.set(e);
            }
            catch (Error e) {
                errorRef.set(e);
            }
            catch (Exception e) {
                exceptionRef.set(new SecureMethodInvocationException(e));
            }
        };
        SecurityManager prevSecurityManager = System.getSecurityManager();
        try {
            Thread thread = new Thread(runnable);
            thread.setName("Low privilege runner");
            thread.start();
            thread.join();
            System.setSecurityManager(prevSecurityManager);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SecureMethodInvoker.throwIfNonEmpty(exceptionRef, errorRef);
        return (T)result.get();
    }

    private static void throwIfNonEmpty(AtomicReference<RuntimeException> exceptionRef, AtomicReference<Error> errorRef) {
        RuntimeException exception = exceptionRef.get();
        if (exception != null) {
            throw exception;
        }
        Error error = errorRef.get();
        if (error != null) {
            throw error;
        }
    }

    public static class SecureMethodInvocationException
    extends RuntimeException {
        public SecureMethodInvocationException(Exception e) {
            super(e);
        }
    }
}

