/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.maven.sandbox.BambooSpecsSecurityManager;
import com.atlassian.bamboo.specs.maven.sandbox.ThreadPermissionVerifier;
import com.atlassian.bamboo.specs.maven.sandbox.internal.InternalSecurityManager;
import java.security.AccessControlException;
import java.security.Permission;

public abstract class AbstractThreadPermissionVerifier
implements ThreadPermissionVerifier {
    private static final SecurityManager DELEGATE = new InternalSecurityManager();

    @Override
    public final void checkPermission(Permission perm) {
        BambooSpecsSecurityManager.log("Checking: " + perm);
        try {
            DELEGATE.checkPermission(perm);
        }
        catch (AccessControlException e) {
            if (this.checkPermissionFor(perm)) {
                BambooSpecsSecurityManager.log("Allowing " + perm + " for low privilege");
            }
            throw e;
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        DELEGATE.checkPermission(perm, context);
    }

    protected abstract boolean checkPermissionFor(Permission var1);
}

