/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven.sandbox;

import com.atlassian.bamboo.specs.maven.sandbox.AbstractThreadPermissionVerifier;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Permission;
import java.util.PropertyPermission;
import java.util.logging.LoggingPermission;
import org.jetbrains.annotations.Nullable;

public class LowPrivilegeThreadPermissionVerifier
extends AbstractThreadPermissionVerifier {
    private final String allowedReadDirectory;
    private final String allowedReadWriteDirectory;

    public LowPrivilegeThreadPermissionVerifier(@Nullable Path allowedReadDirectory, @Nullable Path allowedReadWriteDirectory) {
        try {
            this.allowedReadDirectory = allowedReadDirectory != null ? LowPrivilegeThreadPermissionVerifier.toCanonicalPath(allowedReadDirectory.toString()) : null;
            this.allowedReadWriteDirectory = allowedReadWriteDirectory != null ? LowPrivilegeThreadPermissionVerifier.toCanonicalPath(allowedReadWriteDirectory.toString()) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean checkPermissionFor(Permission perm) {
        boolean allowedFileAccess = this.isAllowedFileAccess(perm);
        return allowedFileAccess || LowPrivilegeThreadPermissionVerifier.isPropertyAccess(perm) || LowPrivilegeThreadPermissionVerifier.isLoggerFinderAccess(perm) || LowPrivilegeThreadPermissionVerifier.isLoggerControlAccess(perm);
    }

    private static boolean isPropertyAccess(Permission perm) {
        if (!(perm instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)perm;
        return propertyPermission.getActions().equals("read");
    }

    private static boolean isLoggerFinderAccess(Permission perm) {
        if (!(perm instanceof RuntimePermission)) {
            return false;
        }
        RuntimePermission runtimePermission = (RuntimePermission)perm;
        return "loggerFinder".equals(runtimePermission.getName());
    }

    private static boolean isLoggerControlAccess(Permission perm) {
        if (!(perm instanceof LoggingPermission)) {
            return false;
        }
        LoggingPermission loggingPermission = (LoggingPermission)perm;
        return "control".equals(loggingPermission.getName());
    }

    private boolean isAllowedFileAccess(Permission perm) {
        String fileName;
        if (!(perm instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)perm;
        try {
            fileName = LowPrivilegeThreadPermissionVerifier.toCanonicalPath(filePermission.getName());
        }
        catch (IOException e) {
            return false;
        }
        boolean isWriteRequested = filePermission.getActions().equals("write");
        if (isWriteRequested) {
            return this.allowedReadWriteDirectory != null && fileName.startsWith(this.allowedReadWriteDirectory);
        }
        boolean isReadRequested = filePermission.getActions().equals("read");
        if (!isReadRequested) {
            return false;
        }
        if (fileName.endsWith(".class") || fileName.endsWith(".jar")) {
            return true;
        }
        if (this.allowedReadDirectory != null && fileName.startsWith(this.allowedReadDirectory)) {
            return true;
        }
        return this.allowedReadWriteDirectory != null && fileName.startsWith(this.allowedReadWriteDirectory);
    }

    private static String toCanonicalPath(String pathString) throws IOException {
        return new File(pathString).getCanonicalPath();
    }

    @Nullable
    private static String toAbsolutePath(@Nullable Path path) {
        return path != null ? path.toAbsolutePath().toString() : null;
    }
}

