/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.repository.github;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.SharedCredentialsAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.github.GitHubRepositoryProperties;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class GitHubRepository
extends VcsRepository<GitHubRepository, GitHubRepositoryProperties> {
    private String repository;
    private String branch;
    private AuthenticationProperties authentication;
    private boolean useShallowClones;
    private boolean useRemoteAgentCache = true;
    private boolean useSubmodules;
    private boolean sshKeyAppliesToSubmodules;
    private Duration commandTimeout = Duration.ofMinutes(180L);
    private boolean verboseLogs;
    private boolean fetchWholeRepository;
    private boolean useLfs;
    private String baseUrl = "https://github.com";
    private VcsChangeDetectionProperties vcsChangeDetection;

    public GitHubRepository repository(@NotNull String repository) {
        ImporterUtils.checkNotBlank((String)"repository", (String)repository);
        this.repository = repository;
        return this;
    }

    public GitHubRepository branch(@NotNull String branch) {
        ImporterUtils.checkNotNull((String)"branch", (Object)branch);
        this.branch = branch;
        return this;
    }

    public GitHubRepository authentication(@NotNull UserPasswordAuthentication userPasswordAuthentication) {
        ImporterUtils.checkNotNull((String)"userPasswordAuthentication", (Object)((Object)userPasswordAuthentication));
        this.authentication = (AuthenticationProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)userPasswordAuthentication);
        return this;
    }

    public GitHubRepository authentication(@NotNull SharedCredentialsIdentifier sharedCredentialsIdentifier) {
        ImporterUtils.checkNotNull((String)"sharedCredentialsIdentifier", (Object)sharedCredentialsIdentifier);
        this.authentication = new SharedCredentialsAuthenticationProperties((SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentialsIdentifier));
        return this;
    }

    public GitHubRepository shallowClonesEnabled(boolean useShallowClones) {
        this.useShallowClones = useShallowClones;
        return this;
    }

    public GitHubRepository submodulesEnabled(boolean useSubmodules) {
        this.useSubmodules = useSubmodules;
        return this;
    }

    public GitHubRepository sshKeyAppliesToSubmodules(boolean sshKeyAppliesToSubmodules) {
        this.sshKeyAppliesToSubmodules = sshKeyAppliesToSubmodules;
        return this;
    }

    public GitHubRepository remoteAgentCacheEnabled(boolean useRemoteAgentCache) {
        this.useRemoteAgentCache = useRemoteAgentCache;
        return this;
    }

    public GitHubRepository commandTimeout(Duration commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public GitHubRepository commandTimeoutInMinutes(int commandTimeoutMinutes) {
        return this.commandTimeout(Duration.ofMinutes(commandTimeoutMinutes));
    }

    public GitHubRepository verboseLogs(boolean verboseLogs) {
        this.verboseLogs = verboseLogs;
        return this;
    }

    public GitHubRepository fetchWholeRepository(boolean fetchWholeRepository) {
        this.fetchWholeRepository = fetchWholeRepository;
        return this;
    }

    public GitHubRepository lfsEnabled(boolean useLfs) {
        this.useLfs = useLfs;
        return this;
    }

    public GitHubRepository defaultChangeDetection() {
        this.vcsChangeDetection = null;
        return this;
    }

    public GitHubRepository baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public GitHubRepository changeDetection(@NotNull VcsChangeDetection vcsChangeDetection) {
        ImporterUtils.checkNotNull((String)"vcsChangeDetection", (Object)vcsChangeDetection);
        this.vcsChangeDetection = (VcsChangeDetectionProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)vcsChangeDetection);
        return this;
    }

    protected GitHubRepositoryProperties build() throws PropertiesValidationException {
        return new GitHubRepositoryProperties(this.name, this.oid, this.description, this.parent, this.repositoryViewer, this.repository, this.branch, this.project, this.authentication, this.vcsChangeDetection, this.useShallowClones, this.useRemoteAgentCache, this.useSubmodules, this.sshKeyAppliesToSubmodules, this.commandTimeout, this.verboseLogs, this.fetchWholeRepository, this.useLfs, this.baseUrl);
    }
}

