/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task.docker;

import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.DockerPushImageTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.DockerRegistryEmitter;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Builder(value=DockerPushImageTask.class)
@CodeGenerator(value=DockerRegistryEmitter.class)
@Immutable
public class DockerRegistryTaskProperties
extends AbstractDockerTaskProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Docker Push/Pull image task:");
    @NotNull
    private OperationType operationType;
    @NotNull
    private String image;
    @NotNull
    private RegistryType registryType;
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private String email;
    @Nullable
    private SharedCredentialsIdentifierProperties sharedCredentialsIdentifier;

    protected DockerRegistryTaskProperties() {
    }

    public DockerRegistryTaskProperties(@Nullable String description, boolean enabled, @NotNull OperationType operationType, @NotNull String image, @NotNull RegistryType registryType, @Nullable String username, @Nullable String password, @Nullable String email, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions, @Nullable SharedCredentialsIdentifierProperties sharedCredentialsIdentifierProperties) throws PropertiesValidationException {
        super(description, enabled, environmentVariables, workingSubdirectory, requirements, conditions);
        this.operationType = (OperationType)((Object)ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"operationType", (Object)((Object)operationType)));
        this.registryType = (RegistryType)((Object)ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"registryType", (Object)((Object)registryType)));
        this.image = image;
        this.username = username;
        this.password = password;
        this.email = email;
        this.sharedCredentialsIdentifier = sharedCredentialsIdentifierProperties;
        this.validate();
    }

    @NotNull
    public String getImage() {
        return this.image;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public SharedCredentialsIdentifierProperties getSharedCredentialsIdentifier() {
        return this.sharedCredentialsIdentifier;
    }

    @NotNull
    public OperationType getOperationType() {
        return this.operationType;
    }

    @NotNull
    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public void validate() {
        super.validate();
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"repository", (String)this.image);
        if (StringUtils.isNotBlank((CharSequence)this.username) || StringUtils.isNotBlank((CharSequence)this.password)) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"username", (String)this.username);
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"password", (String)this.password);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerRegistryTaskProperties that = (DockerRegistryTaskProperties)((Object)o);
        return this.operationType == that.operationType && Objects.equals(this.image, that.image) && this.registryType == that.registryType && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.email, that.email) && Objects.equals(this.sharedCredentialsIdentifier, that.sharedCredentialsIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operationType, this.image, this.registryType, this.username, this.password, this.sharedCredentialsIdentifier, this.email});
    }

    public static enum OperationType {
        PUSH,
        PULL;

    }

    public static enum RegistryType {
        DOCKER_HUB,
        CUSTOM;

    }
}

