/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task.docker;

import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.DockerRunContainerTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.DockerRunContainerEmitter;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Builder(value=DockerRunContainerTask.class)
@CodeGenerator(value=DockerRunContainerEmitter.class)
@Immutable
public final class DockerRunContainerTaskProperties
extends AbstractDockerTaskProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Docker run container task:");
    public static final long DEFAULT_SERVICE_TIMEOUT = 120L;
    @NotNull
    private String imageName;
    @Setter(value="detachContainer")
    private boolean detachedContainer;
    @Nullable
    private String containerName;
    @NotNull
    private Map<Integer, Integer> portMappings;
    private boolean waitToStart;
    private String serviceURLPattern;
    private long serviceTimeout;
    private boolean linkToDetachedContainers;
    @Nullable
    private String containerEnvironmentVariables;
    @Nullable
    private String containerCommand;
    @Nullable
    private String containerWorkingDirectory;
    @Nullable
    private String additionalArguments;
    @NotNull
    private final Map<String, String> volumeMappings;

    private DockerRunContainerTaskProperties() {
        this.volumeMappings = new LinkedHashMap<String, String>();
        this.volumeMappings.put("${bamboo.working.directory}", "/data");
        this.workingSubdirectory = "/data";
        this.serviceTimeout = 120L;
    }

    public DockerRunContainerTaskProperties(@Nullable String description, boolean enabled, @NotNull String imageName, boolean detachedContainer, @Nullable String containerName, @NotNull Map<Integer, Integer> portMappings, boolean waitToStart, @Nullable String serviceURLPattern, long serviceTimeout, boolean linkToDetachedContainers, @Nullable String containerEnvironmentVariables, @Nullable String containerCommand, @Nullable String containerWorkingDirectory, @Nullable String additionalArguments, @NotNull Map<String, String> volumeMappings, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, environmentVariables, workingSubdirectory, requirements, conditions);
        this.imageName = imageName;
        this.detachedContainer = detachedContainer;
        this.containerName = containerName;
        this.portMappings = portMappings;
        this.waitToStart = waitToStart;
        this.serviceURLPattern = serviceURLPattern;
        this.serviceTimeout = serviceTimeout;
        this.linkToDetachedContainers = linkToDetachedContainers;
        this.containerEnvironmentVariables = containerEnvironmentVariables;
        this.containerCommand = containerCommand;
        this.containerWorkingDirectory = containerWorkingDirectory;
        this.additionalArguments = additionalArguments;
        this.volumeMappings = volumeMappings;
        this.validate();
    }

    @NotNull
    public String getImageName() {
        return this.imageName;
    }

    public boolean isDetachedContainer() {
        return this.detachedContainer;
    }

    @Nullable
    public String getContainerName() {
        return this.containerName;
    }

    public Map<Integer, Integer> getPortMappings() {
        return this.portMappings == null ? Collections.emptyMap() : this.portMappings;
    }

    public boolean isWaitToStart() {
        return this.waitToStart;
    }

    public String getServiceURLPattern() {
        return this.serviceURLPattern;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public boolean isLinkToDetachedContainers() {
        return this.linkToDetachedContainers;
    }

    @Nullable
    public String getContainerEnvironmentVariables() {
        return this.containerEnvironmentVariables;
    }

    @Nullable
    public String getContainerCommand() {
        return this.containerCommand;
    }

    @Nullable
    public String getContainerWorkingDirectory() {
        return this.containerWorkingDirectory;
    }

    @Nullable
    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @NotNull
    public Map<String, String> getVolumeMappings() {
        return this.volumeMappings == null ? Collections.emptyMap() : this.volumeMappings;
    }

    public void validate() {
        super.validate();
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"imageName", (String)this.imageName);
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"portMappings", this.portMappings);
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"volumeMappings", this.volumeMappings);
        HashSet<Integer> occupiedContainerPorts = new HashSet<Integer>();
        for (Integer n : this.portMappings.values()) {
            if (occupiedContainerPorts.add(n)) continue;
            throw new PropertiesValidationException(VALIDATION_CONTEXT, "Port " + n + " is already defined.");
        }
        HashSet<String> occupiedContainerVolumes = new HashSet<String>();
        for (String containerVolume : this.volumeMappings.values()) {
            if (occupiedContainerVolumes.add(containerVolume)) continue;
            throw new PropertiesValidationException(VALIDATION_CONTEXT, "Volume " + containerVolume + " is already defined.");
        }
        List list = this.portMappings.entrySet().stream().filter(entry -> !this.isPortValid((Integer)entry.getKey()) || !this.isPortValid((Integer)entry.getValue())).map(entry -> String.format("[%d,%d]", entry.getKey(), entry.getValue())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw new PropertiesValidationException(VALIDATION_CONTEXT, "Specified port mappings are invalid: " + String.valueOf(list));
        }
        List invalidVolumeMappings = this.volumeMappings.entrySet().stream().filter(entry -> StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))).map(entry -> String.format("[%s, %s]", entry.getKey(), entry.getValue())).collect(Collectors.toList());
        if (!invalidVolumeMappings.isEmpty()) {
            throw new PropertiesValidationException(VALIDATION_CONTEXT, "Specified volume mappings are invalid: " + String.valueOf(invalidVolumeMappings));
        }
        if (this.detachedContainer) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"containerName", (String)this.containerName);
        }
        if (this.waitToStart) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"serviceURLPattern", (String)this.serviceURLPattern);
            ImporterUtils.checkPositive((ValidationContext)VALIDATION_CONTEXT, (String)"serviceTimeout", (long)this.serviceTimeout);
            ImporterUtils.checkThat((ValidationContext)VALIDATION_CONTEXT, (!this.portMappings.isEmpty() ? 1 : 0) != 0, (String)"No port mappings defined", (Object[])new Object[0]);
        }
    }

    private boolean isPortValid(Integer port) {
        return port != null && port > 0 && port <= 65535;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerRunContainerTaskProperties that = (DockerRunContainerTaskProperties)((Object)o);
        return this.detachedContainer == that.detachedContainer && this.waitToStart == that.waitToStart && this.serviceTimeout == that.serviceTimeout && this.linkToDetachedContainers == that.linkToDetachedContainers && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.containerName, that.containerName) && Objects.equals(this.portMappings, that.portMappings) && Objects.equals(this.serviceURLPattern, that.serviceURLPattern) && Objects.equals(this.containerEnvironmentVariables, that.containerEnvironmentVariables) && Objects.equals(this.containerCommand, that.containerCommand) && Objects.equals(this.containerWorkingDirectory, that.containerWorkingDirectory) && Objects.equals(this.additionalArguments, that.additionalArguments) && Objects.equals(this.volumeMappings, that.volumeMappings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.imageName, this.detachedContainer, this.containerName, this.portMappings, this.waitToStart, this.serviceURLPattern, this.serviceTimeout, this.linkToDetachedContainers, this.containerEnvironmentVariables, this.containerCommand, this.containerWorkingDirectory, this.additionalArguments, this.volumeMappings);
    }
}

