/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.trigger;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.CronExpressionClientSideValidator;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class RepositoryPollingTriggerProperties
extends RepositoryBasedTriggerProperties {
    public static final String MODULE_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll";
    private static final String NAME = "Repository polling";
    private static final AtlassianModuleProperties MODULE = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new AtlassianModule("com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll"));
    private static final int DEFAULT_POLLING_PERIOD = InliningUtils.preventInlining((int)180);
    private final Duration pollingPeriod;
    private final String cronExpression;
    private final PollType pollType;

    private RepositoryPollingTriggerProperties() {
        super(NAME, null, true, Collections.emptySet(), RepositoryBasedTrigger.TriggeringRepositoriesType.ALL, Collections.emptyList());
        this.pollingPeriod = Duration.ofSeconds(DEFAULT_POLLING_PERIOD);
        this.cronExpression = null;
        this.pollType = PollType.PERIOD;
    }

    @Deprecated
    public RepositoryPollingTriggerProperties(String description, boolean isEnabled, Set<TriggerConditionProperties> conditions, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> triggeringRepositories, String cronExpression) {
        super(NAME, description, isEnabled, conditions, triggeringRepositoriesType, triggeringRepositories);
        this.cronExpression = cronExpression;
        this.pollingPeriod = null;
        this.pollType = PollType.CRON;
        this.validate();
    }

    public RepositoryPollingTriggerProperties(String name, String description, boolean isEnabled, Set<TriggerConditionProperties> conditions, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> triggeringRepositories, String cronExpression) {
        super((String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)NAME), description, isEnabled, conditions, triggeringRepositoriesType, triggeringRepositories);
        this.cronExpression = cronExpression;
        this.pollingPeriod = null;
        this.pollType = PollType.CRON;
        this.validate();
    }

    @Deprecated
    public RepositoryPollingTriggerProperties(String description, boolean isEnabled, Set<TriggerConditionProperties> conditions, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories, Duration pollingPeriod) {
        super(NAME, description, isEnabled, conditions, triggeringRepositoriesType, selectedTriggeringRepositories);
        this.cronExpression = null;
        this.pollingPeriod = pollingPeriod;
        this.pollType = PollType.PERIOD;
        this.validate();
    }

    public RepositoryPollingTriggerProperties(String name, String description, boolean isEnabled, Set<TriggerConditionProperties> conditions, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories, Duration pollingPeriod) {
        super((String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)NAME), description, isEnabled, conditions, triggeringRepositoriesType, selectedTriggeringRepositories);
        this.cronExpression = null;
        this.pollingPeriod = pollingPeriod;
        this.pollType = PollType.PERIOD;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return MODULE;
    }

    public PollType getPollType() {
        return this.pollType;
    }

    @Nullable
    public Duration getPollingPeriod() {
        return this.pollingPeriod;
    }

    @Nullable
    public String getCronExpression() {
        return this.cronExpression;
    }

    public void validate() {
        super.validate();
        if (this.pollType == null) {
            throw new PropertiesValidationException("Can't create repository polling trigger without any polling type");
        }
        switch (this.pollType) {
            case PERIOD: {
                ImporterUtils.checkNotNull((String)"pollingPeriod", (Object)this.pollingPeriod);
                ImporterUtils.checkPositive((String)"pollingPeriod", (int)((int)this.pollingPeriod.getSeconds()));
                break;
            }
            case CRON: {
                CronExpressionClientSideValidator.validate((String)this.cronExpression);
                break;
            }
            default: {
                throw new PropertiesValidationException("Can't create repository polling trigger - unknown polling type: " + String.valueOf((Object)this.pollType));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryPollingTriggerProperties that = (RepositoryPollingTriggerProperties)((Object)o);
        return Objects.equals(this.pollingPeriod, that.pollingPeriod) && Objects.equals(this.cronExpression, that.cronExpression) && this.pollType == that.pollType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.pollingPeriod, this.cronExpression, this.pollType});
    }

    public static enum PollType {
        PERIOD,
        CRON;

    }
}

