/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.Yamlizator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

class IncludeTag
extends AbstractConstruct {
    private static final String YAML_SUFFIX_1 = ".yaml";
    private static final String YAML_SUFFIX_2 = ".yml";
    private final int maxDepth;
    private final int depth;
    private final Path yamlParentDirectory;

    IncludeTag(int maxDepth, int depth, Path yamlParentDirectory) {
        this.maxDepth = maxDepth;
        this.depth = depth;
        this.yamlParentDirectory = yamlParentDirectory;
    }

    public Object construct(Node node) {
        ScalarNode sn = (ScalarNode)node;
        String includeFileName = sn.getValue();
        Path includeFilePath = this.getIncludeFilePath(includeFileName, this.yamlParentDirectory);
        InputStream inputStream = null;
        try {
            if (this.depth >= this.maxDepth) {
                throw new YAMLException("To many recursive include calls");
            }
            Yaml yamlWithRepositoryIncludes = Yamlizator.getYamlWithRepositoryIncludes(this.maxDepth, this.depth + 1, this.yamlParentDirectory);
            inputStream = new FileInputStream(includeFilePath.toString());
            Object object = yamlWithRepositoryIncludes.load(inputStream);
            return object;
        }
        catch (FileNotFoundException e) {
            throw new YAMLException(String.format("Include file %s not found", includeFileName), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    throw new YAMLException("", (Throwable)ioe);
                }
            }
        }
    }

    private Path getIncludeFilePath(String filePath, Path yamlParentDirectory) {
        Path includeFilePath = Paths.get(filePath, new String[0]);
        if (!includeFilePath.isAbsolute()) {
            includeFilePath = Paths.get(String.valueOf(yamlParentDirectory.toAbsolutePath()) + FileSystems.getDefault().getSeparator() + filePath, new String[0]);
        }
        if (!Files.exists(includeFilePath, new LinkOption[0])) {
            throw new YAMLException(String.format("Include file %s does not exist", filePath));
        }
        if (!Files.isReadable(includeFilePath)) {
            throw new YAMLException(String.format("Include file %s is not readable", filePath));
        }
        if (Files.isSymbolicLink(includeFilePath)) {
            throw new YAMLException(String.format("Include file %s is a symbolic link", filePath));
        }
        if (!filePath.endsWith(YAML_SUFFIX_1) && !filePath.endsWith(YAML_SUFFIX_2)) {
            throw new YAMLException(String.format("Include file %s has not proper suffix %s or %s", filePath, YAML_SUFFIX_1, YAML_SUFFIX_2));
        }
        File yamlDirectoryFile = yamlParentDirectory.toFile();
        File includeFile = includeFilePath.toFile();
        try {
            if (!includeFile.getCanonicalPath().startsWith(yamlDirectoryFile.getCanonicalPath() + FileSystems.getDefault().getSeparator())) {
                throw new YAMLException(String.format("Include file %s is not in the source directory %s", filePath, yamlDirectoryFile.getCanonicalPath()));
            }
        }
        catch (IOException ioe) {
            throw new YAMLException(String.format("Include file %s", filePath), (Throwable)ioe);
        }
        return includeFilePath.toAbsolutePath();
    }
}

