/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.exceptions.BambooSpecsRestRequestException;
import com.atlassian.bamboo.specs.util.AuthenticationProvider;
import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.specs.util.Logger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class RestHelper {
    private static final Logger log = Logger.getLogger(RestHelper.class);
    private static final String MIME_TYPE_APPLICATION_X_YAML = "application/x-yaml";

    private static String sendRequest(HttpRequestBase request, AuthenticationProvider authenticationProvider) throws IOException {
        Registry registry = RegistryBuilder.create().register("Digest", (Object)new DigestSchemeFactory()).build();
        log.trace("%s - sending", request);
        try {
            authenticationProvider.authenticate(request);
        }
        catch (AuthenticationException exception) {
            throw new RuntimeException(exception);
        }
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)registry).build();){
            ResponseHandler responseHandler = response -> {
                int status = response.getStatusLine().getStatusCode();
                Optional<String> responseEntityAsString = RestHelper.getResponseEntityAsString(response);
                if (status >= 200 && status < 300) {
                    log.trace("%s - successful, status: %d", request, status);
                    responseEntityAsString.ifPresent(x$0 -> log.trace((String)x$0, new Object[0]));
                    return "Result OK: " + responseEntityAsString.orElse("");
                }
                Optional errorMessage = responseEntityAsString.flatMap(RestHelper::tryGetErrorMessageFromResponse);
                log.trace("%s - failed, status: %d, error: %s", request, status, errorMessage.orElse("<unknown>"));
                responseEntityAsString.ifPresent(x$0 -> log.trace((String)x$0, new Object[0]));
                throw new BambooSpecsRestRequestException(status, errorMessage.orElse(null), responseEntityAsString.orElse(null));
            };
            String string = (String)httpClient.execute((HttpUriRequest)request, responseHandler);
            return string;
        }
    }

    @NotNull
    static Optional<String> tryGetErrorMessageFromResponse(String jsonAsString) {
        try {
            JsonObject jsonObject = new JsonParser().parse(jsonAsString).getAsJsonObject();
            String message = null;
            if (jsonObject.has("message")) {
                String prefixToRemove;
                message = jsonObject.get("message").getAsString();
                if (message.startsWith(prefixToRemove = PropertiesValidationException.class.getName() + ":")) {
                    message = StringUtils.substringAfter((String)message, (String)prefixToRemove).trim();
                }
            } else if (jsonObject.has("errors") && jsonObject.has("fieldErrors")) {
                message = String.join((CharSequence)"; ", RestHelper.extractErrorsFromRestErrorCollection(jsonObject));
            }
            return Optional.ofNullable(message);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static List<String> extractErrorsFromRestErrorCollection(JsonObject jsonObject) {
        ArrayList<String> messages = new ArrayList<String>();
        JsonArray errors = jsonObject.get("errors").getAsJsonArray();
        StreamSupport.stream(errors.spliterator(), false).map(JsonElement::getAsString).forEach(messages::add);
        Set fieldErrors = jsonObject.get("fieldErrors").getAsJsonObject().entrySet();
        fieldErrors.forEach(fieldErrorEntry -> {
            String fieldName = (String)fieldErrorEntry.getKey();
            JsonArray fieldErrorsArray = ((JsonElement)fieldErrorEntry.getValue()).getAsJsonArray();
            StreamSupport.stream(fieldErrorsArray.spliterator(), false).map(JsonElement::getAsString).forEach(fieldError -> messages.add(fieldName + ": " + fieldError));
        });
        return messages;
    }

    private static Optional<String> getResponseEntityAsString(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        return entity != null ? Optional.of(EntityUtils.toString((HttpEntity)entity)) : Optional.empty();
    }

    public String post(URI uri, AuthenticationProvider authenticationProvider, String yamlContent) throws IOException {
        log.trace("Sending the following content to %s via POST:\n%s", uri, yamlContent);
        HttpPost httpPost = new HttpPost(uri);
        this.setYamlEntity((HttpEntityEnclosingRequest)httpPost, yamlContent);
        return RestHelper.sendRequest((HttpRequestBase)httpPost, authenticationProvider);
    }

    public String put(URI uri, AuthenticationProvider authenticationProvider, String yamlContent) throws IOException {
        log.trace("Sending the following content to %s via PUT:\n%s", uri, yamlContent);
        HttpPut httpPut = new HttpPut(uri);
        this.setYamlEntity((HttpEntityEnclosingRequest)httpPut, yamlContent);
        return RestHelper.sendRequest((HttpRequestBase)httpPut, authenticationProvider);
    }

    private void setYamlEntity(HttpEntityEnclosingRequest request, String yamlContent) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("version", BambooSpecVersion.getModelVersion()));
        boolean skipBugFixVersionCheck = Boolean.parseBoolean(System.getProperty("bamboo.specs.skip.bug.fix.version.check"));
        if (skipBugFixVersionCheck) {
            params.add(new BasicNameValuePair("validationIgnoreLevel", "IGNORE_BUG_FIX_ONLY"));
        }
        ContentType contentType = ContentType.create((String)MIME_TYPE_APPLICATION_X_YAML, (Charset)StandardCharsets.UTF_8).withParameters(params.toArray(new NameValuePair[0]));
        StringEntity entity = new StringEntity(yamlContent, contentType);
        request.setEntity((HttpEntity)entity);
    }
}

