/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.permission.DeploymentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.EnvironmentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.PlanPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.ProjectPermissions;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.util.AuthenticationProvider;
import java.net.URI;

public final class RestTaskFactory {
    private RestTaskFactory() {
    }

    public static RestTask create(URI bambooServerUrl, AuthenticationProvider authenticationProvider, RootEntityPropertiesBuilder entity, String payload) {
        String entityApiUrl = RestTaskFactory.getApiUrl(entity);
        URI restEndpointUri = bambooServerUrl.resolve(entityApiUrl);
        String humanReadableId = entity.humanReadableId();
        return new RestTask(restEndpointUri, authenticationProvider, humanReadableId, payload);
    }

    private static String getApiUrl(RootEntityPropertiesBuilder entity) {
        if (entity instanceof Plan) {
            return "rest/api/latest/import/plan";
        }
        if (entity instanceof Deployment) {
            return "rest/api/latest/import/deployment";
        }
        if (entity instanceof VcsRepository) {
            return "rest/api/latest/import/repository";
        }
        if (entity instanceof SharedCredentials) {
            return "rest/api/latest/import/sharedCredentials";
        }
        if (entity instanceof PlanPermissions) {
            return "rest/api/latest/import/plan/permission";
        }
        if (entity instanceof DeploymentPermissions) {
            return "rest/api/latest/import/deployment/permission";
        }
        if (entity instanceof EnvironmentPermissions) {
            return "rest/api/latest/import/deployment/environment/permission";
        }
        if (entity instanceof Project) {
            return "rest/api/latest/import/project";
        }
        if (entity instanceof ProjectPermissions) {
            return "rest/api/latest/import/project/permissions";
        }
        throw new IllegalArgumentException("Unknown entity " + String.valueOf(entity.getClass()));
    }

    public static final class RestTask {
        private final URI restEndpointUri;
        private final AuthenticationProvider userPasswordCredentials;
        private final String humanReadableId;
        private final String yamlString;

        private RestTask(URI restEndpointUri, AuthenticationProvider authenticationProvider, String humanReadableId, String yamlString) {
            this.restEndpointUri = restEndpointUri;
            this.userPasswordCredentials = authenticationProvider;
            this.humanReadableId = humanReadableId;
            this.yamlString = yamlString;
        }

        public URI getRestEndpointUri() {
            return this.restEndpointUri;
        }

        public AuthenticationProvider getAuthenticationProvider() {
            return this.userPasswordCredentials;
        }

        public String getHumanReadableId() {
            return this.humanReadableId;
        }

        public String getYamlString() {
            return this.yamlString;
        }
    }
}

