/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.bitbucket.server;

import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.applink.ApplicationLinkProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.model.repository.bitbucket.server.BitbucketServerMirrorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class BitbucketServerRepositoryProperties
extends VcsRepositoryProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver");
    private final ApplicationLinkProperties server;
    private final String projectKey;
    private final String repositorySlug;
    private final String sshPublicKey;
    private final String sshPrivateKey;
    private final BitbucketServerMirrorProperties mirror;
    private final String sshCloneUrl;
    private String branch;
    @Setter(value="shallowClonesEnabled")
    private final boolean useShallowClones;
    @Setter(value="remoteAgentCacheEnabled")
    private final boolean useRemoteAgentCache;
    @Setter(value="submodulesEnabled")
    private final boolean useSubmodules;
    @Setter(value="submodulesUseShallowClonesEnabled")
    private final boolean useSubmodulesWithShallowClones;
    private final boolean sshKeyAppliesToSubmodules;
    private final Duration commandTimeout;
    private final boolean verboseLogs;
    private final boolean fetchWholeRepository;
    @Setter(value="lfsEnabled")
    private final boolean useLfs;
    private VcsChangeDetectionProperties vcsChangeDetection;

    private BitbucketServerRepositoryProperties() {
        this.server = null;
        this.projectKey = null;
        this.repositorySlug = null;
        this.sshPublicKey = null;
        this.sshPrivateKey = null;
        this.branch = "master";
        this.sshCloneUrl = null;
        this.useShallowClones = false;
        this.sshKeyAppliesToSubmodules = false;
        this.useRemoteAgentCache = true;
        this.useSubmodules = false;
        this.useSubmodulesWithShallowClones = false;
        this.commandTimeout = Duration.ofMinutes(180L);
        this.verboseLogs = false;
        this.fetchWholeRepository = false;
        this.useLfs = false;
        this.mirror = null;
    }

    public BitbucketServerRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable ApplicationLinkProperties server, @Nullable String projectKey, @Nullable String repositorySlug, @Nullable String sshPublicKey, @Nullable String sshPrivateKey, @Nullable String sshCloneUrl, @Nullable String branch, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, boolean useSubmodulesWithShallowClones, boolean sshKeyAppliesToSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs, @Nullable BitbucketServerMirrorProperties mirror) throws PropertiesValidationException {
        this(name, oid, description, parent, repositoryViewerProperties, server, projectKey, repositorySlug, sshPublicKey, sshPrivateKey, sshCloneUrl, branch, null, vcsChangeDetection, useShallowClones, useRemoteAgentCache, useSubmodules, useSubmodulesWithShallowClones, sshKeyAppliesToSubmodules, commandTimeout, verboseLogs, fetchWholeRepository, useLfs, mirror);
    }

    public BitbucketServerRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable ApplicationLinkProperties server, @Nullable String projectKey, @Nullable String repositorySlug, @Nullable String sshPublicKey, @Nullable String sshPrivateKey, @Nullable String sshCloneUrl, @Nullable String branch, @Nullable ProjectProperties project, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, boolean useSubmodulesWithShallowClones, boolean sshKeyAppliesToSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs, @Nullable BitbucketServerMirrorProperties mirror) throws PropertiesValidationException {
        super(name, oid, description, parent, repositoryViewerProperties, project);
        this.server = server;
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.sshPublicKey = sshPublicKey;
        this.sshPrivateKey = sshPrivateKey;
        this.branch = branch;
        this.sshCloneUrl = sshCloneUrl;
        this.vcsChangeDetection = vcsChangeDetection;
        this.useRemoteAgentCache = useRemoteAgentCache;
        this.useShallowClones = useShallowClones;
        this.useSubmodules = useSubmodules;
        this.useSubmodulesWithShallowClones = useSubmodulesWithShallowClones;
        this.sshKeyAppliesToSubmodules = sshKeyAppliesToSubmodules;
        this.commandTimeout = commandTimeout;
        this.verboseLogs = verboseLogs;
        this.fetchWholeRepository = fetchWholeRepository;
        this.useLfs = useLfs;
        this.mirror = mirror;
        this.validate();
    }

    @Nullable
    public ApplicationLinkProperties getServer() {
        return this.server;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Nullable
    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    @Nullable
    public String getSshPrivateKey() {
        return this.sshPrivateKey;
    }

    public String getSshCloneUrl() {
        return this.sshCloneUrl;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseRemoteAgentCache() {
        return this.useRemoteAgentCache;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public boolean isUseSubmodulesWithShallowClones() {
        return this.useSubmodulesWithShallowClones;
    }

    public boolean isSshKeyAppliesToSubmodules() {
        return this.sshKeyAppliesToSubmodules;
    }

    @Nullable
    public Duration getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public boolean isFetchWholeRepository() {
        return this.fetchWholeRepository;
    }

    public boolean isUseLfs() {
        return this.useLfs;
    }

    public VcsChangeDetectionProperties getVcsChangeDetection() {
        return this.vcsChangeDetection;
    }

    public BitbucketServerMirrorProperties getMirror() {
        return this.mirror;
    }

    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BitbucketServerRepositoryProperties that = (BitbucketServerRepositoryProperties)((Object)o);
        return this.isUseShallowClones() == that.isUseShallowClones() && this.isUseRemoteAgentCache() == that.isUseRemoteAgentCache() && this.isUseSubmodules() == that.isUseSubmodules() && this.isUseSubmodulesWithShallowClones() == that.isUseSubmodulesWithShallowClones() && this.isSshKeyAppliesToSubmodules() == that.isSshKeyAppliesToSubmodules() && this.isVerboseLogs() == that.isVerboseLogs() && this.isFetchWholeRepository() == that.isFetchWholeRepository() && this.isUseLfs() == that.isUseLfs() && Objects.equals(this.getServer(), that.getServer()) && Objects.equals(this.getProjectKey(), that.getProjectKey()) && Objects.equals(this.getRepositorySlug(), that.getRepositorySlug()) && Objects.equals(this.getSshPublicKey(), that.getSshPublicKey()) && Objects.equals(this.getSshPrivateKey(), that.getSshPrivateKey()) && Objects.equals(this.getBranch(), that.getBranch()) && Objects.equals(this.getCommandTimeout(), that.getCommandTimeout()) && Objects.equals(this.getVcsChangeDetection(), that.getVcsChangeDetection()) && Objects.equals(this.getMirror(), that.getMirror()) && Objects.equals(this.getSshCloneUrl(), that.getSshCloneUrl());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServer(), this.getProjectKey(), this.getRepositorySlug(), this.getSshPublicKey(), this.getSshPrivateKey(), this.getBranch(), this.isUseShallowClones(), this.isUseRemoteAgentCache(), this.isUseSubmodules(), this.isUseSubmodulesWithShallowClones(), this.isSshKeyAppliesToSubmodules(), this.getCommandTimeout(), this.isVerboseLogs(), this.isFetchWholeRepository(), this.isUseLfs(), this.getVcsChangeDetection(), this.getMirror(), this.getSshCloneUrl());
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Bitbucket Server repository");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (!this.hasParent() || this.anyServerPropertyDefined()) {
            ImporterUtils.checkRequired((ValidationContext)context.with("server"), (Object)this.server);
            ImporterUtils.checkRequiredNotBlank((ValidationContext)context.with("projectKey"), (String)this.projectKey);
            ImporterUtils.checkRequiredNotBlank((ValidationContext)context.with("repositorySlug"), (String)this.repositorySlug);
            if (this.sshPublicKey != null || this.sshPrivateKey != null) {
                ImporterUtils.checkRequiredNotBlank((ValidationContext)context.with("sshPublicKey"), (String)this.sshPublicKey);
                ImporterUtils.checkRequiredNotBlank((ValidationContext)context.with("sshPrivateKey"), (String)this.sshPrivateKey);
            }
            if (this.sshCloneUrl != null) {
                try {
                    URI uri = new URI(this.sshCloneUrl);
                    String scheme = uri.getScheme();
                    if (!"ssh".equals(scheme)) {
                        errors.add(new ValidationProblem(context, "Clone url should be ssh url"));
                    }
                }
                catch (URISyntaxException e) {
                    errors.add(new ValidationProblem(context, String.format("Malformed URL: %s", this.sshCloneUrl)));
                }
            }
        }
        if (!this.hasParent() && StringUtils.isBlank((CharSequence)this.branch)) {
            this.branch = "master";
        }
        if (this.branch != null) {
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("Branch name"), (String)this.branch).ifPresent(errors::add);
        }
        if (this.vcsChangeDetection != null && !this.vcsChangeDetection.getConfiguration().isEmpty()) {
            errors.add(new ValidationProblem(context.with("Change detection"), "Git repository cannot have any extra change detection configuration."));
        }
        ImporterUtils.checkNoErrors(errors);
    }

    private boolean anyServerPropertyDefined() {
        return this.server != null || this.projectKey != null || this.repositorySlug != null || this.sshPublicKey != null || this.sshPrivateKey != null;
    }
}

