/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.Logger;
import com.atlassian.bamboo.specs.util.RestHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class BambooSpecVersion {
    private static final Logger log;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String BAMBOO_SPECS_VERSION_PROPERTY = "bamboo-specs.version";
    private static final String MODEL_VERSION;

    private BambooSpecVersion() {
    }

    @NotNull
    public static String getModelVersion() {
        return MODEL_VERSION;
    }

    static {
        String modelVersion;
        log = Logger.getLogger(RestHelper.class);
        try (InputStream inputStream = BambooSpecVersion.class.getClassLoader().getResourceAsStream("bamboo-specs.properties");){
            if (inputStream == null) {
                throw new IOException("Can't find bamboo-specs.proprties");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = properties.getProperty(BAMBOO_SPECS_VERSION_PROPERTY);
            modelVersion = StringUtils.isNotBlank((CharSequence)version) ? version : UNKNOWN;
        }
        catch (Exception e) {
            Object errorMessage = "Couldn't read the Bamboo Specs version";
            if (e.getMessage() != null) {
                errorMessage = (String)errorMessage + ", because: " + e.getMessage();
            }
            log.info((String)errorMessage, new Object[0]);
            throw new RuntimeException(e);
        }
        MODEL_VERSION = modelVersion;
    }
}

