/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.value;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.codegen.CompoundFieldSetterEmitter;
import com.atlassian.bamboo.specs.api.codegen.Condition;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.codegen.annotations.DefaultFieldValues;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGenIf;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.codegen.BuilderClassProvider;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.fragment.FieldSetterEmitterFactory;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityPropertiesEmitter<T extends EntityProperties>
implements CodeEmitter<T> {
    protected Class<?> builderClass;
    protected final Set<String> fieldsToSkip = new HashSet<String>();

    @Nullable
    protected Field findField(Class<?> clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            return fields[i];
        }
        Class<?> superclass = clazz.getSuperclass();
        if (EntityProperties.class.isAssignableFrom(superclass)) {
            return this.findField(superclass, fieldName);
        }
        return null;
    }

    protected boolean hasPublicConstructor(Class<?> builderClass, Class<?> ... argTypes) {
        try {
            builderClass.getDeclaredConstructor(argTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected String emitConstructorInvocation(@NotNull CodeGenerationContext context, @NotNull T entity) throws CodeGenerationException {
        this.initBuilderClass(entity);
        StringBuilder builder = new StringBuilder();
        if (entity.getClass().isAnnotationPresent(ConstructFrom.class)) {
            ConstructFrom annotation = entity.getClass().getAnnotation(ConstructFrom.class);
            String[] fieldNames = annotation.value();
            builder.append("new " + context.importClassName(this.builderClass) + "(");
            context.incIndentation();
            ArrayList<String> valuesAndFails = new ArrayList<String>();
            HashSet<Integer> failed = new HashSet<Integer>();
            for (int i = 0; i < fieldNames.length; ++i) {
                Field field = this.findField(entity.getClass(), fieldNames[i]);
                if (field == null) {
                    throw new IllegalStateException("Field " + fieldNames[i] + " not found in class " + entity.getClass().getCanonicalName());
                }
                field.setAccessible(true);
                try {
                    valuesAndFails.add(this.emitFieldValue(context, (EntityProperties)entity, field));
                }
                catch (CodeGenerationException e) {
                    valuesAndFails.add(e.getMessage());
                    failed.add(i);
                }
                this.fieldsToSkip.add(fieldNames[i]);
            }
            CodeGenerationUtils.appendCommaSeparatedList(context, builder, valuesAndFails, failed);
            context.decIndentation();
            builder.append(")");
        } else if (this.hasPublicConstructor(this.builderClass, new Class[0])) {
            builder.append("new " + context.importClassName(this.builderClass) + "()");
        } else if (this.hasPublicConstructor(this.builderClass, AtlassianModule.class)) {
            try {
                builder.append("new " + context.importClassName(this.builderClass) + "(");
                builder.append("new " + context.importClassName(AtlassianModule.class) + "(\"");
                builder.append(this.getAtlassianPluginKey((EntityProperties)entity));
                builder.append("\"))");
            }
            catch (Exception e) {
                throw new CodeGenerationException("Code generation failed. Could not generate constructor invocation for " + this.builderClass.getCanonicalName());
            }
            this.fieldsToSkip.add("atlassianPlugin");
        } else {
            throw new CodeGenerationException("Code generation failed. Could not find suitable constructor for " + this.builderClass.getCanonicalName());
        }
        return builder.toString();
    }

    private String getAtlassianPluginKey(EntityProperties entity) throws Exception {
        Method atlassianModuleGetter = entity.getClass().getMethod("getAtlassianPlugin", new Class[0]);
        return ((AtlassianModuleProperties)atlassianModuleGetter.invoke((Object)entity, new Object[0])).getCompleteModuleKey();
    }

    protected String emitFieldValue(CodeGenerationContext context, EntityProperties entity, Field field) throws CodeGenerationException {
        try {
            Object fieldValue = field.get(entity);
            CodeEmitter<Object> codeEmitter = ValueEmitterFactory.emitterFor(fieldValue);
            return codeEmitter.emitCode(context, fieldValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not get value of field " + field.getName() + " from instance of " + entity.getClass().getCanonicalName());
        }
    }

    protected EntityProperties createDefaultObject(EntityProperties rootObject) {
        for (Method method : rootObject.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(DefaultFieldValues.class)) continue;
            method.setAccessible(true);
            try {
                return (EntityProperties)method.invoke((Object)rootObject, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return null;
            }
        }
        try {
            Constructor constructor = rootObject.getClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (EntityProperties)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Object getFieldValue(EntityProperties entityObject, Field field) {
        try {
            return field.get(entityObject);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not get value of field " + field.getName() + " from instance of " + entityObject.getClass().getCanonicalName());
        }
    }

    private String invokeCodeEmitterForField(CodeEmitter codeEmitter, CodeGenerationContext context, EntityProperties entityObject, Object fieldValue) throws CodeGenerationException {
        if (codeEmitter instanceof CompoundFieldSetterEmitter) {
            return ((CompoundFieldSetterEmitter)codeEmitter).emitCode(context, (Object)entityObject);
        }
        return codeEmitter.emitCode(context, fieldValue);
    }

    private String emitFields(CodeGenerationContext context, EntityProperties entity, Class<?> entityClass, Class<?> builderClass, EntityProperties entityObject, Set<String> fieldsAlreadyCovered, @Nullable EntityProperties defaultObject) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        Class<?> superclass = entityClass.getSuperclass();
        if (EntityProperties.class.isAssignableFrom(superclass)) {
            builder.append(this.emitFields(context, entity, superclass, builderClass, entityObject, fieldsAlreadyCovered, defaultObject));
        }
        for (Field field : entityClass.getDeclaredFields()) {
            Object fieldValue;
            field.setAccessible(true);
            if (field.isAnnotationPresent(SkipCodeGen.class)) continue;
            if (field.isAnnotationPresent(SkipCodeGenIf.class)) {
                Class conditionClass = field.getAnnotation(SkipCodeGenIf.class).value();
                try {
                    Condition condition = (Condition)conditionClass.newInstance();
                    if (condition.evaluate(entity)) {
                        continue;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CodeGenerationException("Could not instantiate condition class " + conditionClass.getCanonicalName(), (Throwable)e);
                }
            }
            if (fieldsAlreadyCovered.contains(field.getName()) || Modifier.isStatic(field.getModifiers()) || CodeGenerationUtils.isEmptyField(fieldValue = this.getFieldValue(entityObject, field)) || defaultObject != null && Objects.equals(fieldValue, this.getFieldValue(defaultObject, field))) continue;
            try {
                CodeEmitter<Object> codeEmitter = FieldSetterEmitterFactory.fieldSetterEmitterFor(context, builderClass, field, fieldValue);
                String fieldCode = this.invokeCodeEmitterForField(codeEmitter, context, entityObject, fieldValue);
                if (!StringUtils.isNotBlank((CharSequence)fieldCode)) continue;
                builder.append(context.newLine());
                builder.append(fieldCode);
            }
            catch (CodeGenerationException e) {
                builder.append(context.newLine());
                builder.append("//todo: Could not generate code to set field " + field.getName() + ": " + e.getMessage());
                builder.append(context.newLine());
            }
        }
        return builder.toString();
    }

    protected String emitFields(@NotNull CodeGenerationContext context, @NotNull EntityProperties entity) throws CodeGenerationException {
        context.incIndentation();
        String code = this.emitFields(context, entity, entity.getClass(), this.builderClass, entity, this.fieldsToSkip, this.createDefaultObject(entity));
        context.decIndentation();
        return code;
    }

    protected void initBuilderClass(@NotNull T entity) throws CodeGenerationException {
        if (this.builderClass == null) {
            this.builderClass = BuilderClassProvider.findBuilderClass(entity.getClass());
        }
        if (this.builderClass == null) {
            throw new IllegalStateException("Builder class not set.");
        }
    }

    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull T entity) throws CodeGenerationException {
        this.initBuilderClass(entity);
        return this.emitConstructorInvocation(context, entity) + this.emitFields(context, (EntityProperties)entity);
    }
}

