/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.github;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.repository.GitHubAppAuthenticationEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.repository.GitHubPatAuthenticationEmitter;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubRepositoryProperties
extends VcsRepositoryProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gh2");
    private static final Set<String> SUPPORTED_SCHEMES = Stream.of("https", "http").collect(Collectors.toSet());
    public static final boolean DEFAULT_WEBHOOK_ENABLED = false;
    public static final String DEFAULT_BASE_URL = "https://github.com";
    private final String repository;
    private String branch;
    @CodeGenerator(value=GitHubPatAuthenticationEmitter.class)
    private final AuthenticationProperties patAuthenticationProperties;
    private final String appId;
    @CodeGenerator(value=GitHubAppAuthenticationEmitter.class)
    private final AuthenticationProperties appAuthenticationProperties;
    @Setter(value="shallowClonesEnabled")
    private final boolean useShallowClones;
    @Setter(value="remoteAgentCacheEnabled")
    private final boolean useRemoteAgentCache;
    @Setter(value="submodulesEnabled")
    private final boolean useSubmodules;
    @Setter(value="submodulesUseShallowClonesEnabled")
    private final boolean useSubmodulesWithShallowClones;
    private final boolean sshKeyAppliesToSubmodules;
    private final Duration commandTimeout;
    private final boolean verboseLogs;
    private final boolean fetchWholeRepository;
    @Setter(value="lfsEnabled")
    private final boolean useLfs;
    private final boolean webhookEnabled;
    private VcsChangeDetectionProperties vcsChangeDetection;
    private String baseUrl;

    private GitHubRepositoryProperties() {
        this.repository = null;
        this.branch = null;
        this.patAuthenticationProperties = null;
        this.appId = null;
        this.appAuthenticationProperties = null;
        this.useShallowClones = false;
        this.useRemoteAgentCache = true;
        this.useSubmodules = false;
        this.useSubmodulesWithShallowClones = false;
        this.sshKeyAppliesToSubmodules = false;
        this.commandTimeout = Duration.ofMinutes(180L);
        this.verboseLogs = false;
        this.fetchWholeRepository = false;
        this.useLfs = false;
        this.baseUrl = DEFAULT_BASE_URL;
        this.webhookEnabled = false;
    }

    public GitHubRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable String repository, @Nullable String branch, @Nullable AuthenticationProperties patAuthenticationProperties, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, boolean useSubmodulesWithShallowClones, boolean sshKeyAppliesToSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs, String baseUrl, boolean webhookEnabled, @Nullable String appId, @Nullable AuthenticationProperties appAuthenticationProperties) throws PropertiesValidationException {
        this(name, oid, description, parent, repositoryViewerProperties, repository, branch, null, patAuthenticationProperties, vcsChangeDetection, useShallowClones, useRemoteAgentCache, useSubmodules, useSubmodulesWithShallowClones, sshKeyAppliesToSubmodules, commandTimeout, verboseLogs, fetchWholeRepository, useLfs, baseUrl, webhookEnabled, appId, appAuthenticationProperties);
    }

    public GitHubRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable String repository, @Nullable String branch, @Nullable ProjectProperties project, @Nullable AuthenticationProperties patAuthenticationProperties, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, boolean useSubmodulesWithShallowClones, boolean sshKeyAppliesToSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs, String baseUrl, boolean webhookEnabled, @Nullable String appId, @Nullable AuthenticationProperties appAuthenticationProperties) throws PropertiesValidationException {
        super(name, oid, description, parent, repositoryViewerProperties, project);
        this.repository = repository;
        this.branch = branch;
        this.patAuthenticationProperties = patAuthenticationProperties;
        this.vcsChangeDetection = vcsChangeDetection;
        this.useRemoteAgentCache = useRemoteAgentCache;
        this.useShallowClones = useShallowClones;
        this.useSubmodules = useSubmodules;
        this.useSubmodulesWithShallowClones = useSubmodulesWithShallowClones;
        this.sshKeyAppliesToSubmodules = sshKeyAppliesToSubmodules;
        this.commandTimeout = commandTimeout;
        this.verboseLogs = verboseLogs;
        this.fetchWholeRepository = fetchWholeRepository;
        this.useLfs = useLfs;
        this.baseUrl = baseUrl;
        this.webhookEnabled = webhookEnabled;
        this.appId = appId;
        this.appAuthenticationProperties = appAuthenticationProperties;
        if (!this.hasParent() && StringUtils.isBlank((CharSequence)this.branch)) {
            this.branch = "master";
        }
        this.validate();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranch() {
        return this.branch;
    }

    public AuthenticationProperties getPatAuthenticationProperties() {
        return this.patAuthenticationProperties;
    }

    public String getAppId() {
        return this.appId;
    }

    public AuthenticationProperties getAppAuthenticationProperties() {
        return this.appAuthenticationProperties;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseRemoteAgentCache() {
        return this.useRemoteAgentCache;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public boolean isUseSubmodulesWithShallowClones() {
        return this.useSubmodulesWithShallowClones;
    }

    public boolean isSshKeyAppliesToSubmodules() {
        return this.sshKeyAppliesToSubmodules;
    }

    public Duration getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public boolean isFetchWholeRepository() {
        return this.fetchWholeRepository;
    }

    public boolean isUseLfs() {
        return this.useLfs;
    }

    public VcsChangeDetectionProperties getVcsChangeDetection() {
        return this.vcsChangeDetection;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isWebhookEnabled() {
        return this.webhookEnabled;
    }

    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitHubRepositoryProperties that = (GitHubRepositoryProperties)((Object)o);
        return this.isUseShallowClones() == that.isUseShallowClones() && this.isUseRemoteAgentCache() == that.isUseRemoteAgentCache() && this.isUseSubmodules() == that.isUseSubmodules() && this.isUseSubmodulesWithShallowClones() == that.isUseSubmodulesWithShallowClones() && this.isSshKeyAppliesToSubmodules() == that.isSshKeyAppliesToSubmodules() && this.isVerboseLogs() == that.isVerboseLogs() && this.isFetchWholeRepository() == that.isFetchWholeRepository() && this.isUseLfs() == that.isUseLfs() && this.isWebhookEnabled() == that.isWebhookEnabled() && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getBranch(), that.getBranch()) && Objects.equals(this.getPatAuthenticationProperties(), that.getPatAuthenticationProperties()) && Objects.equals(this.getCommandTimeout(), that.getCommandTimeout()) && Objects.equals(this.getVcsChangeDetection(), that.getVcsChangeDetection()) && Objects.equals(this.getBaseUrl(), that.getBaseUrl()) && Objects.equals(this.getAppId(), that.getAppId()) && Objects.equals(this.getAppAuthenticationProperties(), that.getAppAuthenticationProperties());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRepository(), this.getBranch(), this.getPatAuthenticationProperties(), this.isUseShallowClones(), this.isUseRemoteAgentCache(), this.isUseSubmodules(), this.isUseSubmodulesWithShallowClones(), this.isSshKeyAppliesToSubmodules(), this.getCommandTimeout(), this.isVerboseLogs(), this.isFetchWholeRepository(), this.isUseLfs(), this.isWebhookEnabled(), this.getVcsChangeDetection(), this.getBaseUrl(), this.getAppId(), this.getAppAuthenticationProperties());
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"GitHub repository");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        this.checkAuthentication(context, this.patAuthenticationProperties, this.appId, this.appAuthenticationProperties).ifPresent(errors::add);
        if (!this.hasParent()) {
            ImporterUtils.checkRequired((ValidationContext)context.with("repository"), (Object)this.repository);
            ValidationUtils.validateNotContainsRelaxedXssRelatedCharacters((ValidationContext)context.with("repository"), (String)this.repository).ifPresent(errors::add);
        }
        if (this.baseUrl != null && !ValidationUtils.containsBambooVariable((String)this.baseUrl)) {
            ValidationUtils.validateNotContainsRelaxedXssRelatedCharacters((ValidationContext)context.with("URL"), (String)this.baseUrl).ifPresent(errors::add);
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("URL"), (String)this.baseUrl).ifPresent(errors::add);
            this.checkUrl(context.with("URL")).ifPresent(errors::add);
        }
        if (this.branch != null) {
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("Branch name"), (String)this.branch).ifPresent(errors::add);
        }
        if (this.vcsChangeDetection != null && !this.vcsChangeDetection.getConfiguration().isEmpty()) {
            errors.add(new ValidationProblem(context.with("Change detection"), "GitHub repository cannot have any extra change detection configuration."));
        }
        ImporterUtils.checkNoErrors(errors);
    }

    private Optional<ValidationProblem> checkUrl(@NotNull ValidationContext validationContext) {
        if (this.baseUrl == null) {
            return Optional.empty();
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            return Optional.empty();
        }
        try {
            URI uri = new URI(this.baseUrl);
            String scheme = uri.getScheme();
            if (!SUPPORTED_SCHEMES.contains(uri.getScheme())) {
                return Optional.of(new ValidationProblem(validationContext, "scheme '%s' is not supported - supported schemes are: %s", new Object[]{scheme, String.join((CharSequence)", ", SUPPORTED_SCHEMES)}));
            }
        }
        catch (URISyntaxException e) {
            return Optional.of(new ValidationProblem(validationContext, String.format("Malformed Base URL: %s", this.baseUrl)));
        }
        return Optional.empty();
    }

    private Optional<ValidationProblem> checkAuthentication(@NotNull ValidationContext validationContext, @Nullable AuthenticationProperties patAuthenticationProperties, @Nullable String appId, @Nullable AuthenticationProperties appAuthenticationProperties) {
        if (patAuthenticationProperties == null && (appId == null || appAuthenticationProperties == null)) {
            return Optional.of(new ValidationProblem(validationContext, "You must configure an authentication method; either personal access token or GitHub app."));
        }
        return Optional.empty();
    }
}

