/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class ScriptTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.scripttask:task.builder.script");
    private final Interpreter interpreter;
    private final Location location;
    @Nullable
    private final String body;
    @Nullable
    private final String path;
    @Nullable
    private final String argument;
    @Nullable
    private final String environmentVariables;
    @Nullable
    private final String workingSubdirectory;

    private ScriptTaskProperties() {
        this.interpreter = Defaults.getDefaultInterpreter();
        this.location = Defaults.getDefaultLocation();
        this.body = null;
        this.path = null;
        this.argument = null;
        this.environmentVariables = null;
        this.workingSubdirectory = null;
    }

    public ScriptTaskProperties(String description, boolean enabled, @Nullable Interpreter interpreter, @Nullable Location location, @Nullable String body, @Nullable String path, @Nullable String argument, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, requirements, conditions);
        this.interpreter = Defaults.getOrDefaultInterpreter(interpreter);
        this.location = Defaults.getOrDefaultLocation(location);
        this.body = body;
        this.path = path;
        this.argument = argument;
        this.environmentVariables = environmentVariables;
        this.workingSubdirectory = workingSubdirectory;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public Location getLocation() {
        return this.location;
    }

    @Nullable
    public String getBody() {
        return this.body;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getArgument() {
        return this.argument;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }

    public void validate() throws PropertiesValidationException {
        ValidationContext context = ValidationContext.of((String)"Script task");
        ImporterUtils.checkRequired((ValidationContext)context.with("location"), (Object)((Object)this.location));
        ImporterUtils.checkRequired((ValidationContext)context.with("interpreter"), (Object)((Object)this.interpreter));
        switch (this.location.ordinal()) {
            case 0: {
                ImporterUtils.checkArgument((ValidationContext)context.with("body"), (!StringUtils.isEmpty((CharSequence)this.body) ? 1 : 0) != 0, (Object)String.format("Script body cannot be empty when location is set to %s", new Object[]{this.location}));
                ImporterUtils.checkArgument((ValidationContext)context.with("path"), (boolean)StringUtils.isEmpty((CharSequence)this.path), (Object)String.format("Script path cannot be set when location is set to %s", new Object[]{this.location}));
                break;
            }
            case 1: {
                ImporterUtils.checkArgument((ValidationContext)context.with("path"), (!StringUtils.isEmpty((CharSequence)this.path) ? 1 : 0) != 0, (Object)String.format("Script path cannot be empty when location is set to %s", new Object[]{this.location}));
                ImporterUtils.checkArgument((ValidationContext)context.with("body"), (boolean)StringUtils.isEmpty((CharSequence)this.body), (Object)String.format("Script body cannot be set when location is set to %s", new Object[]{this.location}));
                break;
            }
            default: {
                throw new PropertiesValidationException(String.format("Script location %s is not supported", new Object[]{this.location}));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScriptTaskProperties that = (ScriptTaskProperties)((Object)o);
        return this.getInterpreter() == that.getInterpreter() && this.getLocation() == that.getLocation() && Objects.equals(this.getBody(), that.getBody()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getArgument(), that.getArgument()) && Objects.equals(this.getEnvironmentVariables(), that.getEnvironmentVariables()) && Objects.equals(this.getWorkingSubdirectory(), that.getWorkingSubdirectory());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getInterpreter(), this.getLocation(), this.getBody(), this.getPath(), this.getArgument(), this.getEnvironmentVariables(), this.getWorkingSubdirectory()});
    }

    private static final class Defaults {
        private Defaults() {
        }

        static Interpreter getDefaultInterpreter() {
            return Interpreter.SHELL;
        }

        static Interpreter getOrDefaultInterpreter(@Nullable Interpreter interpreter) {
            return interpreter != null ? interpreter : Defaults.getDefaultInterpreter();
        }

        static Location getDefaultLocation() {
            return Location.INLINE;
        }

        static Location getOrDefaultLocation(@Nullable Location location) {
            return location != null ? location : Defaults.getDefaultLocation();
        }
    }

    public static enum Interpreter {
        SHELL,
        WINDOWS_POWER_SHELL,
        BINSH_OR_CMDEXE;

    }

    public static enum Location {
        INLINE,
        FILE;

    }
}

