/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.LogUtils;
import com.atlassian.bamboo.specs.util.Logger;
import com.atlassian.bamboo.specs.util.RestHelper;
import com.atlassian.bamboo.specs.util.TokenCredentials;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class FileTokenCredentials
implements TokenCredentials {
    private static final Logger log = Logger.getLogger(FileTokenCredentials.class);
    protected static final String TOKEN_PROPERTY = "token";
    private final String token;

    public FileTokenCredentials() {
        this(".credentials");
    }

    public FileTokenCredentials(@Nonnull String credentialsLocation) {
        Properties properties = FileTokenCredentials.loadProperties(credentialsLocation);
        this.token = FileTokenCredentials.getPropertyOrThrow(properties, TOKEN_PROPERTY, credentialsLocation);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    protected static Properties loadProperties(String credentialsLocation) {
        Properties properties = new Properties();
        try {
            File credentialsFile = new File(credentialsLocation);
            log.debug("Looking for credentials file: %s", credentialsFile.getAbsolutePath());
            if (credentialsFile.exists()) {
                log.debug("Credentials file found: %s", credentialsFile.getAbsolutePath());
                properties.load(new FileReader(credentialsFile));
            } else {
                log.debug("Credentials file not found under '%s', scanning JVM classpath for '%s'", credentialsFile.getAbsolutePath(), credentialsLocation);
                InputStream resourceAsStream = FileTokenCredentials.class.getClassLoader().getResourceAsStream(credentialsLocation);
                if (resourceAsStream == null) {
                    log.debug("Credentials not found on JVM classpath: %s", credentialsLocation);
                    log.info("Couldn't find credentials file '%s' to access Bamboo", credentialsLocation);
                    log.info("Please make sure that the path points to an existing file or to a resource available on JVM classpath", new Object[0]);
                    LogUtils.hintLogLevel(log, Logger.LogLevel.DEBUG);
                    throw new RuntimeException(String.format("Couldn't find credentials file: %s", credentialsLocation));
                }
                log.debug("Found credentials file on JVM classpath: %s", credentialsLocation);
                properties.load(RestHelper.class.getClassLoader().getResourceAsStream(credentialsLocation));
            }
            return properties;
        }
        catch (IOException e) {
            log.info("Couldn't read credentials file '%s' to access Bamboo", credentialsLocation);
            log.info("Please make sure that the file is accessible and that it is in correct format (Java properties)", new Object[0]);
            LogUtils.hintLogLevel(log, Logger.LogLevel.DEBUG);
            throw new RuntimeException(e);
        }
    }

    protected static String getPropertyOrThrow(Properties properties, String propertyKey, String fileName) {
        String propertyValue = properties.getProperty(propertyKey);
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            log.info("Property '%s' must be defined in credentials file '%s' to access Bamboo", propertyKey, fileName);
            log.info("Please make sure that the file is in correct format (Java properties)", new Object[0]);
            throw new RuntimeException(String.format("Property '%s' was not defined in credentials file: %s", propertyKey, fileName));
        }
        return propertyValue;
    }
}

