/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.task.CheckoutItem;
import com.atlassian.bamboo.specs.model.task.CheckoutItemProperties;
import com.atlassian.bamboo.specs.model.task.VcsCheckoutTaskProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsCheckoutTask
extends Task<VcsCheckoutTask, VcsCheckoutTaskProperties> {
    private List<CheckoutItemProperties> checkoutItems = new ArrayList<CheckoutItemProperties>();
    private boolean cleanCheckout;

    public VcsCheckoutTask addCheckoutOfDefaultRepository() {
        return this.checkoutItems(new CheckoutItem().defaultRepository());
    }

    public VcsCheckoutTask addCheckoutOfRepository(@NotNull String repositoryName) {
        ImporterUtils.checkNotNull((String)"repositoryName", (Object)repositoryName);
        return this.checkoutItems(new CheckoutItem().repository(repositoryName));
    }

    public VcsCheckoutTask addCheckoutOfRepository(@NotNull VcsRepositoryIdentifier repositoryIdentifier) {
        ImporterUtils.checkNotNull((String)"repositoryIdentifier", (Object)repositoryIdentifier);
        return this.checkoutItems(new CheckoutItem().repository(repositoryIdentifier));
    }

    public VcsCheckoutTask checkoutItems(CheckoutItem ... checkoutItems) {
        ImporterUtils.checkNotNull((String)"checkoutItems", (Object)checkoutItems);
        Arrays.stream(checkoutItems).map(CheckoutItem::build).forEach(this.checkoutItems::add);
        return this;
    }

    public VcsCheckoutTask cleanCheckout(boolean cleanCheckout) {
        this.cleanCheckout = cleanCheckout;
        return this;
    }

    @NotNull
    protected VcsCheckoutTaskProperties build() {
        return new VcsCheckoutTaskProperties(this.description, this.taskEnabled, this.checkoutItems, this.cleanCheckout);
    }
}

