/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.model.task.BaseSshTaskProperties;
import org.jetbrains.annotations.NotNull;

class BaseSshTaskAuthenticationEmitter {
    BaseSshTaskAuthenticationEmitter() {
    }

    public String emitCodeForAuthentication(@NotNull BaseSshTaskProperties entity) {
        SharedCredentialsIdentifierProperties sharedCredentials = entity.getSharedCredentialsIdentifierProperties();
        if (sharedCredentials == null) {
            switch (entity.getAuthenticationType()) {
                case PASSWORD: {
                    return String.format(".authenticateWithPassword(%s)", "/* PUT YOUR SENSITIVE INFORMATION HERE*/");
                }
                case KEY_WITHOUT_PASSPHRASE: {
                    return String.format(".authenticateWithKey(%s)", "/* PUT YOUR SENSITIVE INFORMATION HERE*/");
                }
                case KEY_WITH_PASSPHRASE: {
                    return String.format(".authenticateWithKeyWithPassphrase(%s, %s)", "/* PUT YOUR SENSITIVE INFORMATION HERE*/", "/* PUT YOUR SENSITIVE INFORMATION HERE*/");
                }
            }
            return ".unknownAuthorization() //" + (Object)((Object)entity.getAuthenticationType());
        }
        switch (entity.getAuthenticationType()) {
            case PASSWORD: {
                return String.format(".authenticateWithUsernamePasswordSharedCredentials(new SharedCredentialsIdentifier(\"%s\"))", sharedCredentials.getName());
            }
            case KEY_WITHOUT_PASSPHRASE: 
            case KEY_WITH_PASSPHRASE: {
                return String.format(".authenticateWithSshSharedCredentials(new SharedCredentialsIdentifier(\"%s\"))", sharedCredentials.getName());
            }
        }
        return ".unknownSharedCredentialsAuthorization() //" + (Object)((Object)entity.getAuthenticationType());
    }
}

