/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class AntTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties MODULE_PROPERTIES = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.ant:task.builder.ant");
    public static final String DEFAULT_TEST_RESULTS_DIRECTORY = InliningUtils.preventInlining((String)"**/test-reports/*.xml");
    @NotNull
    protected String target;
    @Nullable
    protected String buildFile;
    @Nullable
    protected String environmentVariables;
    @Nullable
    protected String jdk;
    @Nullable
    protected String executableLabel;
    protected boolean hasTests;
    @Setter(value="testResultsPath")
    @NotNull
    protected String testResultsDirectory;
    @Nullable
    protected String workingSubdirectory;

    protected AntTaskProperties() {
        this.testResultsDirectory = DEFAULT_TEST_RESULTS_DIRECTORY;
    }

    public AntTaskProperties(@Nullable String description, boolean enabled, @NotNull String target, @Nullable String buildFile, @Nullable String environmentVariables, @Nullable String jdk, @NotNull String executableLabel, boolean hasTests, @Nullable String testResultsDirectory, @Nullable String workingSubdirectory) throws PropertiesValidationException {
        super(description, enabled);
        this.target = target;
        this.buildFile = buildFile;
        this.environmentVariables = environmentVariables;
        this.jdk = jdk;
        this.executableLabel = executableLabel;
        this.hasTests = hasTests;
        this.testResultsDirectory = StringUtils.isBlank((CharSequence)testResultsDirectory) ? DEFAULT_TEST_RESULTS_DIRECTORY : testResultsDirectory;
        this.workingSubdirectory = workingSubdirectory;
        this.validate();
    }

    @NotNull
    public String getTarget() {
        return this.target;
    }

    @Nullable
    public String getBuildFile() {
        return this.buildFile;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getJdk() {
        return this.jdk;
    }

    @Nullable
    public String getExecutableLabel() {
        return this.executableLabel;
    }

    public boolean isHasTests() {
        return this.hasTests;
    }

    @NotNull
    public String getTestResultsDirectory() {
        return this.testResultsDirectory;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return MODULE_PROPERTIES;
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Ant task");
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.target), (String)"Target is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.executableLabel), (String)"Executable label is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AntTaskProperties that = (AntTaskProperties)((Object)o);
        return this.hasTests == that.hasTests && Objects.equals(this.target, that.target) && Objects.equals(this.buildFile, that.buildFile) && Objects.equals(this.environmentVariables, that.environmentVariables) && Objects.equals(this.jdk, that.jdk) && Objects.equals(this.executableLabel, that.executableLabel) && Objects.equals(this.testResultsDirectory, that.testResultsDirectory) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.target, this.buildFile, this.environmentVariables, this.jdk, this.executableLabel, this.hasTests, this.testResultsDirectory, this.workingSubdirectory);
    }
}

