/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.MochaParserTask;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class MochaParserTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.reporter.mocha");
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Mocha parser task");
    @NotNull
    private String testFilePattern = MochaParserTask.DEFAULT_TEST_FILE_PATTERN;
    @Nullable
    private String workingSubdirectory;
    private boolean pickUpTestResultsCreatedOutsideOfThisBuild;

    protected MochaParserTaskProperties() {
    }

    public MochaParserTaskProperties(@Nullable String description, boolean enabled, @NotNull String testFilePattern, @Nullable String workingSubdirectory, boolean pickUpTestResultsCreatedOutsideOfThisBuild) throws PropertiesValidationException {
        super(description, enabled);
        this.testFilePattern = testFilePattern;
        this.workingSubdirectory = workingSubdirectory;
        this.pickUpTestResultsCreatedOutsideOfThisBuild = pickUpTestResultsCreatedOutsideOfThisBuild;
        this.validate();
    }

    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.testFilePattern), (String)"Test file pattern is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MochaParserTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MochaParserTaskProperties that = (MochaParserTaskProperties)((Object)o);
        return this.isPickUpTestResultsCreatedOutsideOfThisBuild() == that.isPickUpTestResultsCreatedOutsideOfThisBuild() && Objects.equals(this.getTestFilePattern(), that.getTestFilePattern()) && Objects.equals(this.getWorkingSubdirectory(), that.getWorkingSubdirectory());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTestFilePattern(), this.getWorkingSubdirectory(), this.isPickUpTestResultsCreatedOutsideOfThisBuild());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    private ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @NotNull
    public String getTestFilePattern() {
        return this.testFilePattern;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }

    public boolean isPickUpTestResultsCreatedOutsideOfThisBuild() {
        return this.pickUpTestResultsCreatedOutsideOfThisBuild;
    }

    public EnumSet<Applicability> applicableTo() {
        return EnumSet.of(Applicability.PLANS);
    }
}

