/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.DefaultFieldValues;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.model.task.CheckoutItemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class VcsCheckoutTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.vcs:task.vcs.checkout");
    private final List<CheckoutItemProperties> checkoutItems;
    private final boolean cleanCheckout;

    private VcsCheckoutTaskProperties(boolean addDefaultSpec) {
        this.checkoutItems = addDefaultSpec ? Collections.singletonList(CheckoutItemProperties.forDefaultRepository()) : null;
        this.cleanCheckout = false;
    }

    private VcsCheckoutTaskProperties() {
        this(true);
    }

    @DefaultFieldValues
    private VcsCheckoutTaskProperties defaults() {
        return new VcsCheckoutTaskProperties(false);
    }

    public VcsCheckoutTaskProperties(String description, boolean isEnabled, List<CheckoutItemProperties> checkoutItems, boolean cleanCheckout) throws PropertiesValidationException {
        super(description, isEnabled);
        this.checkoutItems = checkoutItems;
        this.cleanCheckout = cleanCheckout;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public List<CheckoutItemProperties> getCheckoutItems() {
        return this.checkoutItems;
    }

    public boolean isCleanCheckout() {
        return this.cleanCheckout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VcsCheckoutTaskProperties that = (VcsCheckoutTaskProperties)((Object)o);
        return this.isCleanCheckout() == that.isCleanCheckout() && Objects.equals(this.getCheckoutItems(), that.getCheckoutItems());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCheckoutItems(), this.isCleanCheckout());
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"VCS checkout task");
        ImporterUtils.checkThat((ValidationContext)context, (this.checkoutItems != null && !this.checkoutItems.isEmpty() ? 1 : 0) != 0, (String)"No repositories to check out are defined", (Object[])new Object[0]);
        HashSet<String> usedPaths = new HashSet<String>();
        HashSet<VcsRepositoryIdentifierProperties> usedRepositories = new HashSet<VcsRepositoryIdentifierProperties>();
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (CheckoutItemProperties checkoutItem : this.checkoutItems) {
            if (usedPaths.contains(checkoutItem.getPath())) {
                problems.add(new ValidationProblem("Duplicate path " + checkoutItem.getPath()));
            }
            usedPaths.add(checkoutItem.getPath());
            if (usedRepositories.contains(checkoutItem.getRepository())) {
                problems.add(new ValidationProblem("Duplicate repository " + checkoutItem.getRepository()));
            }
            usedRepositories.add(checkoutItem.getRepository());
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }
}

