/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.trigger;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.validators.common.InternetAddressValidator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class RemoteTriggerProperties
extends RepositoryBasedTriggerProperties {
    public static final String NAME = "Remote trigger";
    public static final String MODULE_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:remote";
    private static final AtlassianModuleProperties ATLASSIAN_MODULE = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new AtlassianModule("com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:remote"));
    private final String triggerIPAddresses;

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE;
    }

    private RemoteTriggerProperties() {
        super(NAME, null, true, RepositoryBasedTrigger.TriggeringRepositoriesType.ALL, Collections.emptyList());
        this.triggerIPAddresses = null;
    }

    public RemoteTriggerProperties(String description, boolean isEnabled, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories, String triggerIPAddresses) {
        super(NAME, description, isEnabled, triggeringRepositoriesType, selectedTriggeringRepositories);
        this.triggerIPAddresses = triggerIPAddresses;
        this.validate();
    }

    public String getTriggerIPAddresses() {
        return this.triggerIPAddresses;
    }

    public void validate() throws PropertiesValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.triggerIPAddresses)) {
            InternetAddressValidator.checkComaSeparatedIpAddressesOrCidrs(this.triggerIPAddresses);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteTriggerProperties that = (RemoteTriggerProperties)((Object)o);
        return Objects.equals(this.getTriggerIPAddresses(), that.getTriggerIPAddresses());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTriggerIPAddresses());
    }
}

