/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class Logger {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
    public static final String LOG_LEVEL_PROPERTY = "bamboo.specs.log.level";
    public static final LogLevel LOG_LEVEL = Logger.getLogLevel();
    private final Class<?> forClass;
    private final PrintStream printStream;

    private Logger(@NotNull Class<?> forClass) {
        this(forClass, System.out);
    }

    Logger(@NotNull Class<?> forClass, @NotNull PrintStream printStream) {
        this.forClass = forClass;
        this.printStream = printStream;
    }

    @NotNull
    public static Logger getLogger(@NotNull Class<?> forClass) {
        return new Logger(forClass);
    }

    public void info(@NotNull String message, Object ... args) {
        this.log(LogLevel.INFO, message, args);
    }

    public void info(@NotNull Throwable throwable) {
        this.log(LogLevel.INFO, throwable);
    }

    public void info(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        this.log(LogLevel.INFO, throwable, message, args);
    }

    public void debug(@NotNull String message, Object ... args) {
        this.log(LogLevel.DEBUG, message, args);
    }

    public void debug(@NotNull Throwable throwable) {
        this.log(LogLevel.DEBUG, throwable);
    }

    public void debug(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        this.log(LogLevel.DEBUG, throwable, message, args);
    }

    public void trace(@NotNull String message, Object ... args) {
        this.log(LogLevel.TRACE, message, args);
    }

    public void trace(@NotNull Throwable throwable) {
        this.log(LogLevel.TRACE, throwable);
    }

    public void trace(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        this.log(LogLevel.TRACE, throwable, message, args);
    }

    public void log(@NotNull LogLevel logLevel, @NotNull String message, Object ... args) {
        if (Logger.getLogLevel().shouldLog(logLevel)) {
            this.prefixLogLine(logLevel);
            this.printStream.println(ArrayUtils.isNotEmpty((Object[])args) ? String.format(message, args) : message);
        }
    }

    public void log(@NotNull LogLevel logLevel, @NotNull Throwable throwable) {
        if (Logger.getLogLevel().shouldLog(logLevel)) {
            this.prefixLogLine(logLevel);
            throwable.printStackTrace(this.printStream);
        }
    }

    public void log(@NotNull LogLevel logLevel, @NotNull Throwable throwable, @NotNull String message, Object ... args) {
        this.log(logLevel, message, args);
        this.log(logLevel, throwable);
    }

    public boolean isInfoEnabled() {
        return Logger.getLogLevel().shouldLog(LogLevel.INFO);
    }

    public boolean isDebugEnabled() {
        return Logger.getLogLevel().shouldLog(LogLevel.DEBUG);
    }

    public boolean isTraceEnabled() {
        return Logger.getLogLevel().shouldLog(LogLevel.TRACE);
    }

    private void prefixLogLine(LogLevel logLevel) {
        this.printStream.print(String.format("%s %s [%s] ", DATE_FORMAT.get().format(new Date()), logLevel.name(), this.forClass.getSimpleName()));
    }

    @NotNull
    private static LogLevel getLogLevel() {
        return Optional.ofNullable(System.getProperty(LOG_LEVEL_PROPERTY)).filter(StringUtils::isNotEmpty).flatMap(levelStr -> Arrays.stream(LogLevel.values()).filter(logLevel -> logLevel.name().equalsIgnoreCase((String)levelStr)).findFirst()).orElse(LogLevel.INFO);
    }

    public static enum LogLevel {
        INFO(1),
        DEBUG(2),
        TRACE(3);

        private final int detailLevel;

        private LogLevel(int detailLevel) {
            this.detailLevel = detailLevel;
        }

        public boolean shouldLog(LogLevel logLevel) {
            return this.detailLevel >= logLevel.detailLevel;
        }
    }
}

