/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.builders.task.AbstractDockerTask;
import com.atlassian.bamboo.specs.model.task.docker.DockerRunContainerTaskProperties;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRunContainerTask
extends AbstractDockerTask<DockerRunContainerTask, DockerRunContainerTaskProperties> {
    @NotNull
    private String imageName;
    private boolean detachContainer;
    @Nullable
    private String containerName;
    @NotNull
    private Map<Integer, Integer> portMappings;
    private boolean waitToStart;
    @Nullable
    private String serviceURLPattern;
    private long serviceTimeout = 120L;
    private boolean linkToDetachedContainers;
    @Nullable
    private String containerEnvironmentVariables;
    @Nullable
    private String containerCommand;
    @Nullable
    private String containerWorkingDirectory;
    @Nullable
    private String additionalArguments;
    private Map<String, String> volumeMappings = new HashMap<String, String>();

    public DockerRunContainerTask() {
        this.portMappings = new HashMap<Integer, Integer>();
        this.volumeMappings = new HashMap<String, String>();
        this.volumeMappings.put("${bamboo.working.directory}", "/data");
        this.containerWorkingDirectory = "/data";
    }

    public DockerRunContainerTask imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public DockerRunContainerTask detachContainer(boolean detachContainer) {
        this.detachContainer = detachContainer;
        return this;
    }

    public DockerRunContainerTask containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public DockerRunContainerTask appendPortMapping(int hostPort, int containerPort) {
        this.portMappings.put(hostPort, containerPort);
        return this;
    }

    public DockerRunContainerTask clearPortMappings() {
        this.portMappings.clear();
        return this;
    }

    public DockerRunContainerTask waitToStart(boolean waitToStart) {
        this.waitToStart = waitToStart;
        return this;
    }

    public DockerRunContainerTask serviceURLPattern(String serviceURLPattern) {
        this.serviceURLPattern = serviceURLPattern;
        return this;
    }

    public DockerRunContainerTask serviceTimeoutInSeconds(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
        return this;
    }

    public DockerRunContainerTask serviceTimeout(Duration serviceTimeout) {
        return this.serviceTimeoutInSeconds(TimeUnit.MINUTES.toSeconds(serviceTimeout.toMinutes()));
    }

    public DockerRunContainerTask linkToDetachedContainers(boolean linkToDetachedContainers) {
        this.linkToDetachedContainers = linkToDetachedContainers;
        return this;
    }

    public DockerRunContainerTask containerEnvironmentVariables(String containerEnvironmentVariables) {
        this.containerEnvironmentVariables = containerEnvironmentVariables;
        return this;
    }

    public DockerRunContainerTask containerCommand(String containerCommand) {
        this.containerCommand = containerCommand;
        return this;
    }

    public DockerRunContainerTask containerWorkingDirectory(String containerWorkingDirectory) {
        this.containerWorkingDirectory = containerWorkingDirectory;
        return this;
    }

    public DockerRunContainerTask additionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
        return this;
    }

    public DockerRunContainerTask appendVolumeMapping(String hostDirectory, String containerDataVolume) {
        this.volumeMappings.put(hostDirectory, containerDataVolume);
        return this;
    }

    public DockerRunContainerTask clearVolumeMappings() {
        this.volumeMappings.clear();
        return this;
    }

    @NotNull
    protected DockerRunContainerTaskProperties build() {
        return new DockerRunContainerTaskProperties(this.description, this.taskEnabled, this.imageName, this.detachContainer, this.containerName, this.portMappings, this.waitToStart, this.serviceURLPattern, this.serviceTimeout, this.linkToDetachedContainers, this.containerEnvironmentVariables, this.containerCommand, this.containerWorkingDirectory, this.additionalArguments, this.volumeMappings, this.environmentVariables, this.workingSubdirectory, this.requirements, this.conditions);
    }
}

