/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGeneratorName;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class CodeGenerationUtils {
    private CodeGenerationUtils() {
    }

    public static void appendCommaSeparatedList(CodeGenerationContext context, StringBuilder builder, List<String> valuesAndFails, Set<Integer> indicesOfFails) {
        for (int i = 0; i < valuesAndFails.size(); ++i) {
            String valueOrFail = valuesAndFails.get(i);
            boolean isFail = indicesOfFails.contains(i);
            if (isFail) {
                builder.append("//").append(valueOrFail).append(context.newLine());
                continue;
            }
            builder.append(valueOrFail);
            if (CodeGenerationUtils.hasMoreValuesToAppend(i, valuesAndFails, indicesOfFails)) {
                builder.append(",");
            }
            if (i >= valuesAndFails.size() - 1) continue;
            builder.append(context.newLine());
        }
    }

    private static boolean hasMoreValuesToAppend(int i, List<String> valuesAndFails, Set<Integer> indicesOfFails) {
        for (int j = i + 1; j < valuesAndFails.size(); ++j) {
            if (indicesOfFails.contains(j)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyField(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        if (fieldValue instanceof String) {
            return StringUtils.isBlank((CharSequence)((String)fieldValue));
        }
        if (fieldValue instanceof Iterable) {
            return !((Iterable)fieldValue).iterator().hasNext();
        }
        if (fieldValue instanceof Map) {
            return ((Map)fieldValue).isEmpty();
        }
        return false;
    }

    public static <T> CodeEmitter<T> findEmitterByAnnotation(AnnotatedElement annotatedElement) throws CodeGenerationException {
        if (annotatedElement.isAnnotationPresent(CodeGenerator.class)) {
            Class emitterClass = annotatedElement.getAnnotation(CodeGenerator.class).value();
            try {
                return (CodeEmitter)emitterClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CodeGenerationException("Could not instantiate emitter class " + emitterClass.getCanonicalName(), (Throwable)e);
            }
        }
        if (annotatedElement.isAnnotationPresent(CodeGeneratorName.class)) {
            String emitterClassName = annotatedElement.getAnnotation(CodeGeneratorName.class).value();
            try {
                Class<?> emitterClass = Class.forName(emitterClassName);
                return (CodeEmitter)emitterClass.newInstance();
            }
            catch (Exception e) {
                throw new CodeGenerationException("Could not instantiate emitter class " + emitterClassName, (Throwable)e);
            }
        }
        return null;
    }
}

