/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.fragment;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class VarargArgumentSetterEmitter
implements CodeEmitter<Iterable<Object>> {
    final String methodName;

    public VarargArgumentSetterEmitter(String methodName) {
        this.methodName = methodName;
    }

    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull Iterable<Object> iterable) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder(".").append(this.methodName).append("(");
        context.incIndentation();
        ArrayList<String> valuesAndFails = new ArrayList<String>();
        HashSet<Integer> failed = new HashSet<Integer>();
        int count = 0;
        for (Object item : iterable) {
            try {
                CodeEmitter<Object> codeEmitter = ValueEmitterFactory.emitterFor(item);
                String argumentCode = codeEmitter.emitCode(context, item);
                valuesAndFails.add(argumentCode);
            }
            catch (CodeGenerationException e) {
                valuesAndFails.add(e.getMessage());
                failed.add(count);
            }
            ++count;
        }
        CodeGenerationUtils.appendCommaSeparatedList(context, builder, valuesAndFails, failed);
        context.decIndentation();
        return builder.append(")").toString();
    }
}

