/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"testType"})
@Immutable
public final class TestParserTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties JUNIT_ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.testresultparser:task.testresultparser.junit");
    private static final AtlassianModuleProperties NUNIT_ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.dotnet:nunit");
    private static final AtlassianModuleProperties TESTNG_ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.testresultparser:task.testresultparser.testng");
    private static final AtlassianModuleProperties MOCHA_ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.reporter.mocha");
    private final TestType testType;
    private final List<String> resultDirectories;
    private final boolean pickUpTestResultsCreatedOutsideOfThisBuild;

    private TestParserTaskProperties() {
        this.testType = TestType.JUNIT;
        this.resultDirectories = Collections.emptyList();
        this.pickUpTestResultsCreatedOutsideOfThisBuild = Defaults.getDefaultPickUpTestResultsCreatedOutsideOfThisBuild();
    }

    public TestParserTaskProperties(TestType testType, String description, boolean enabled, Collection<String> resultDirectories, @Nullable Boolean pickUpTestResultsCreatedOutsideOfThisBuild, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, requirements, conditions);
        this.testType = testType;
        this.resultDirectories = Collections.unmodifiableList(new ArrayList<String>(resultDirectories));
        this.pickUpTestResultsCreatedOutsideOfThisBuild = Defaults.getOrDefaultPickUpTestResultsCreatedOutsideOfThisBuild(pickUpTestResultsCreatedOutsideOfThisBuild);
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        switch (this.testType) {
            case JUNIT: {
                return JUNIT_ATLASSIAN_PLUGIN;
            }
            case TESTNG: {
                return TESTNG_ATLASSIAN_PLUGIN;
            }
            case NUNIT: {
                return NUNIT_ATLASSIAN_PLUGIN;
            }
            case MOCHA: {
                return MOCHA_ATLASSIAN_PLUGIN;
            }
        }
        throw new IllegalStateException("Unsupported test type: " + (Object)((Object)this.testType));
    }

    public TestType getTestType() {
        return this.testType;
    }

    public List<String> getResultDirectories() {
        return this.resultDirectories;
    }

    public boolean getPickUpTestResultsCreatedOutsideOfThisBuild() {
        return this.pickUpTestResultsCreatedOutsideOfThisBuild;
    }

    public void validate() throws PropertiesValidationException {
        ValidationContext context = ValidationContext.of((String)"Test parser task");
        ImporterUtils.checkRequired((ValidationContext)context.with("Test type"), (Object)((Object)this.testType));
        ImporterUtils.checkArgument((ValidationContext)context.with("Result directories"), (!this.resultDirectories.isEmpty() ? 1 : 0) != 0, (Object)"Result directory not set.");
    }

    public EnumSet<Applicability> applicableTo() {
        return EnumSet.of(Applicability.PLANS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestParserTaskProperties that = (TestParserTaskProperties)((Object)o);
        return Objects.equals((Object)this.getTestType(), (Object)that.getTestType()) && Objects.equals(this.getResultDirectories(), that.getResultDirectories()) && Objects.equals(this.getPickUpTestResultsCreatedOutsideOfThisBuild(), that.getPickUpTestResultsCreatedOutsideOfThisBuild());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getTestType(), this.getResultDirectories(), this.getPickUpTestResultsCreatedOutsideOfThisBuild()});
    }

    private static class Defaults {
        private Defaults() {
        }

        static boolean getDefaultPickUpTestResultsCreatedOutsideOfThisBuild() {
            return false;
        }

        static boolean getOrDefaultPickUpTestResultsCreatedOutsideOfThisBuild(@Nullable Boolean pickUpTestResultsCreatedOutsideOfThisBuild) {
            return pickUpTestResultsCreatedOutsideOfThisBuild != null ? pickUpTestResultsCreatedOutsideOfThisBuild : Defaults.getDefaultPickUpTestResultsCreatedOutsideOfThisBuild();
        }
    }

    public static enum TestType {
        JUNIT,
        TESTNG,
        NUNIT,
        MOCHA;

    }
}

