/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.github;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.repository.GitAuthenticationEmitter;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHubRepositoryProperties
extends VcsRepositoryProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gh2");
    private final String repository;
    private String branch;
    @CodeGenerator(value=GitAuthenticationEmitter.class)
    private final AuthenticationProperties authenticationProperties;
    @Setter(value="shallowClonesEnabled")
    private final boolean useShallowClones;
    @Setter(value="remoteAgentCacheEnabled")
    private final boolean useRemoteAgentCache;
    @Setter(value="submodulesEnabled")
    private final boolean useSubmodules;
    private final Duration commandTimeout;
    private final boolean verboseLogs;
    private final boolean fetchWholeRepository;
    @Setter(value="lfsEnabled")
    private final boolean useLfs;
    private VcsChangeDetectionProperties vcsChangeDetection;

    private GitHubRepositoryProperties() {
        this.repository = null;
        this.branch = null;
        this.authenticationProperties = null;
        this.useShallowClones = false;
        this.useRemoteAgentCache = true;
        this.useSubmodules = false;
        this.commandTimeout = Duration.ofMinutes(180L);
        this.verboseLogs = false;
        this.fetchWholeRepository = false;
        this.useLfs = false;
    }

    public GitHubRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable String repository, @Nullable String branch, @Nullable AuthenticationProperties authenticationProperties, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs) throws PropertiesValidationException {
        super(name, oid, description, parent, repositoryViewerProperties);
        this.repository = repository;
        this.branch = branch;
        this.authenticationProperties = authenticationProperties;
        this.vcsChangeDetection = vcsChangeDetection;
        this.useRemoteAgentCache = useRemoteAgentCache;
        this.useShallowClones = useShallowClones;
        this.useSubmodules = useSubmodules;
        this.commandTimeout = commandTimeout;
        this.verboseLogs = verboseLogs;
        this.fetchWholeRepository = fetchWholeRepository;
        this.useLfs = useLfs;
        if (!this.hasParent() && StringUtils.isBlank((CharSequence)this.branch)) {
            this.branch = "master";
        }
        this.validate();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranch() {
        return this.branch;
    }

    public AuthenticationProperties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseRemoteAgentCache() {
        return this.useRemoteAgentCache;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public Duration getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public boolean isFetchWholeRepository() {
        return this.fetchWholeRepository;
    }

    public boolean isUseLfs() {
        return this.useLfs;
    }

    public VcsChangeDetectionProperties getVcsChangeDetection() {
        return this.vcsChangeDetection;
    }

    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitHubRepositoryProperties that = (GitHubRepositoryProperties)((Object)o);
        return this.isUseShallowClones() == that.isUseShallowClones() && this.isUseRemoteAgentCache() == that.isUseRemoteAgentCache() && this.isUseSubmodules() == that.isUseSubmodules() && this.isVerboseLogs() == that.isVerboseLogs() && this.isFetchWholeRepository() == that.isFetchWholeRepository() && this.isUseLfs() == that.isUseLfs() && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getBranch(), that.getBranch()) && Objects.equals(this.getAuthenticationProperties(), that.getAuthenticationProperties()) && Objects.equals(this.getCommandTimeout(), that.getCommandTimeout()) && Objects.equals(this.getVcsChangeDetection(), that.getVcsChangeDetection());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRepository(), this.getBranch(), this.getAuthenticationProperties(), this.isUseShallowClones(), this.isUseRemoteAgentCache(), this.isUseSubmodules(), this.getCommandTimeout(), this.isVerboseLogs(), this.isFetchWholeRepository(), this.isUseLfs(), this.getVcsChangeDetection());
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"GitHub repository");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (!this.hasParent()) {
            ImporterUtils.checkRequired((ValidationContext)context.with("repository"), (Object)this.repository);
        }
        if (this.branch != null) {
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("Branch name"), (String)this.branch).ifPresent(errors::add);
        }
        if (this.vcsChangeDetection != null && !this.vcsChangeDetection.getConfiguration().isEmpty()) {
            errors.add(new ValidationProblem(context.with("Change detection"), "GitHub repository cannot have any extra change detection configuration."));
        }
        ImporterUtils.checkNoErrors(errors);
    }
}

