/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.builders.task.AbstractDockerTask;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDockerRegistryTask<T extends AbstractDockerRegistryTask<T>>
extends AbstractDockerTask<T, DockerRegistryTaskProperties> {
    @NotNull
    protected String image;
    @NotNull
    protected DockerRegistryTaskProperties.RegistryType registryType;
    @Nullable
    protected String username;
    @Nullable
    protected String password;
    @Nullable
    protected String email;
    @Nullable
    protected SharedCredentialsIdentifierProperties sharedCredentialsIdentifier;

    public T dockerHubImage(@NotNull String image) {
        this.image = image;
        this.registryType = DockerRegistryTaskProperties.RegistryType.DOCKER_HUB;
        return (T)((Object)this);
    }

    public T customRegistryImage(@NotNull String image) {
        this.image = image;
        this.registryType = DockerRegistryTaskProperties.RegistryType.CUSTOM;
        return (T)((Object)this);
    }

    public T authentication(@NotNull String username, @NotNull String password, @NotNull String email) {
        return this.usernameAuthentication(username, password, email);
    }

    public T authentication(@NotNull String username, @NotNull String password) {
        return this.usernameAuthentication(username, password, null);
    }

    public T authentication(@NotNull SharedCredentialsIdentifier sharedCredentialsIdentifier) {
        this.sharedCredentialsIdentifier = (SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentialsIdentifier);
        this.username = null;
        this.password = null;
        this.email = null;
        return (T)((Object)this);
    }

    public T defaultAuthentication() {
        return this.usernameAuthentication(null, null, null);
    }

    private T usernameAuthentication(@Nullable String username, @Nullable String password, @Nullable String email) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.sharedCredentialsIdentifier = null;
        return (T)((Object)this);
    }
}

