/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.trigger;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class TagTriggerProperties
extends TriggerProperties {
    public static final String NAME = "Tag trigger";
    public static final String MODULE_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:tag";
    private static final AtlassianModuleProperties ATLASSIAN_MODULE = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new AtlassianModule("com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:tag"));
    private final String filter;
    private final boolean checkingIfTagIsInBranch;

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE;
    }

    private TagTriggerProperties() {
        this(null, true, null, true);
    }

    public TagTriggerProperties(String description, boolean isEnabled, String filter, boolean checkingIfTagIsInBranch) {
        super(NAME, description, isEnabled, Collections.emptySet());
        this.filter = filter;
        this.checkingIfTagIsInBranch = checkingIfTagIsInBranch;
        this.validate();
    }

    public void validate() throws PropertiesValidationException {
        super.validate();
        String filterExpression = StringUtils.trimToNull((String)this.filter);
        if (filterExpression != null) {
            try {
                Pattern.compile(filterExpression);
            }
            catch (PatternSyntaxException e) {
                throw new PropertiesValidationException(String.format("Invalid regex filter: %s", this.filter));
            }
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isCheckingIfTagIsInBranch() {
        return this.checkingIfTagIsInBranch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagTriggerProperties that = (TagTriggerProperties)((Object)o);
        return this.checkingIfTagIsInBranch == that.checkingIfTagIsInBranch && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filter, this.checkingIfTagIsInBranch);
    }
}

