/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.repository.git;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.repository.git.SshPrivateKeyAuthentication;
import com.atlassian.bamboo.specs.builders.repository.git.UserPasswordAuthentication;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.GitRepositoryProperties;
import com.atlassian.bamboo.specs.model.repository.git.SharedCredentialsAuthenticationProperties;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class GitRepository
extends VcsRepository<GitRepository, GitRepositoryProperties> {
    private String url;
    private String branch;
    private AuthenticationProperties authentication;
    private boolean useShallowClones;
    private boolean useRemoteAgentCache = true;
    private boolean useSubmodules;
    private Duration commandTimeout = Duration.ofMinutes(180L);
    private boolean verboseLogs;
    private boolean fetchWholeRepository;
    private boolean useLfs;
    private VcsChangeDetectionProperties vcsChangeDetection;

    public GitRepository url(@NotNull String url) {
        ImporterUtils.checkNotBlank((String)"url", (String)url);
        this.url = url;
        return this;
    }

    public GitRepository branch(@NotNull String branch) {
        ImporterUtils.checkNotNull((String)"branch", (Object)branch);
        this.branch = branch;
        return this;
    }

    public GitRepository withoutAuthentication() {
        this.authentication = null;
        return this;
    }

    public GitRepository authentication(@NotNull SharedCredentialsIdentifier sharedCredentialsIdentifier) {
        ImporterUtils.checkNotNull((String)"sharedCredentialsIdentifier", (Object)sharedCredentialsIdentifier);
        this.authentication = new SharedCredentialsAuthenticationProperties((SharedCredentialsIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)sharedCredentialsIdentifier));
        return this;
    }

    public GitRepository authentication(@NotNull UserPasswordAuthentication userPasswordAuthentication) {
        ImporterUtils.checkNotNull((String)"userPasswordAuthentication", (Object)((Object)userPasswordAuthentication));
        this.authentication = userPasswordAuthentication.build();
        return this;
    }

    public GitRepository authentication(@NotNull SshPrivateKeyAuthentication sshPrivateKeyAuthentication) {
        ImporterUtils.checkNotNull((String)"sshPrivateKeyAuthentication", (Object)((Object)sshPrivateKeyAuthentication));
        this.authentication = sshPrivateKeyAuthentication.build();
        return this;
    }

    public GitRepository shallowClonesEnabled(boolean useShallowClones) {
        this.useShallowClones = useShallowClones;
        return this;
    }

    public GitRepository submodulesEnabled(boolean useSubmodules) {
        this.useSubmodules = useSubmodules;
        return this;
    }

    public GitRepository remoteAgentCacheEnabled(boolean useRemoteAgentCache) {
        this.useRemoteAgentCache = useRemoteAgentCache;
        return this;
    }

    public GitRepository commandTimeout(Duration commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public GitRepository commandTimeoutInMinutes(int commandTimeoutMinutes) {
        return this.commandTimeout(Duration.ofMinutes(commandTimeoutMinutes));
    }

    public GitRepository verboseLogs(boolean verboseLogs) {
        this.verboseLogs = verboseLogs;
        return this;
    }

    public GitRepository fetchWholeRepository(boolean fetchWholeRepository) {
        this.fetchWholeRepository = fetchWholeRepository;
        return this;
    }

    public GitRepository lfsEnabled(boolean useLfs) {
        this.useLfs = useLfs;
        return this;
    }

    public GitRepository defaultChangeDetection() {
        this.vcsChangeDetection = null;
        return this;
    }

    public GitRepository changeDetection(@NotNull VcsChangeDetection vcsChangeDetection) {
        ImporterUtils.checkNotNull((String)"vcsChangeDetection", (Object)vcsChangeDetection);
        this.vcsChangeDetection = (VcsChangeDetectionProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)vcsChangeDetection);
        return this;
    }

    protected GitRepositoryProperties build() {
        return new GitRepositoryProperties(this.name, this.oid, this.description, this.parent, this.repositoryViewer, this.url, this.branch, this.project, this.authentication, this.vcsChangeDetection, this.useShallowClones, this.useRemoteAgentCache, this.useSubmodules, this.commandTimeout, this.verboseLogs, this.fetchWholeRepository, this.useLfs);
    }
}

