/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.bitbucket.cloud;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.repository.BBCloudAccountAuthenticationEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.repository.BBCloudCheckoutAuthenticationEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.repository.BBCloudRepositorySlugEmitter;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitbucketCloudRepositoryProperties
extends VcsRepositoryProperties {
    private static final AtlassianModuleProperties ATLASSIAN_MODULE_PROPERTIES = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-bitbucket:bbCloud");
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Bitbucket Cloud repository");
    public static final boolean DEFAULT_USE_SUBMODULES = false;
    public static final boolean DEFAULT_FETCH_WHOLE_REPOSITORY = false;
    public static final boolean DEFAULT_SHALLOW_CLONES = false;
    public static final boolean DEFAULT_LFS = false;
    public static final boolean DEFAULT_REMOTE_AGENT_CACHE = false;
    public static final boolean DEFAULT_VERBOSE_LOGS = false;
    public static final Duration DEFAULT_COMMAND_TIMEOUT = Duration.ofMinutes(180L);
    @CodeGenerator(value=BBCloudRepositorySlugEmitter.class)
    private final String repositorySlug;
    @CodeGenerator(value=BBCloudAccountAuthenticationEmitter.class)
    private final AuthenticationProperties authenticationProperties;
    @CodeGenerator(value=BBCloudCheckoutAuthenticationEmitter.class)
    private final AuthenticationProperties checkoutAuthenticationProperties;
    private String branch;
    @Setter(value="shallowClonesEnabled")
    private final boolean useShallowClones;
    @Setter(value="remoteAgentCacheEnabled")
    private final boolean useRemoteAgentCache;
    @Setter(value="submodulesEnabled")
    private final boolean useSubmodules;
    private final Duration commandTimeout;
    private final boolean verboseLogs;
    private final boolean fetchWholeRepository;
    @Setter(value="lfsEnabled")
    private final boolean useLfs;
    private VcsChangeDetectionProperties vcsChangeDetection;

    private BitbucketCloudRepositoryProperties() {
        this.branch = "";
        this.repositorySlug = null;
        this.authenticationProperties = null;
        this.checkoutAuthenticationProperties = null;
        this.useSubmodules = false;
        this.fetchWholeRepository = false;
        this.useShallowClones = false;
        this.commandTimeout = DEFAULT_COMMAND_TIMEOUT;
        this.useLfs = false;
        this.useRemoteAgentCache = false;
        this.verboseLogs = false;
    }

    public BitbucketCloudRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @NotNull String repositorySlug, @Nullable AuthenticationProperties authenticationProperties, @Nullable AuthenticationProperties checkoutAuthenticationProperties, @NotNull String branch, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs, VcsChangeDetectionProperties vcsChangeDetection) throws PropertiesValidationException {
        this(name, oid, description, parent, repositoryViewerProperties, repositorySlug, authenticationProperties, checkoutAuthenticationProperties, branch, null, useShallowClones, useRemoteAgentCache, useSubmodules, commandTimeout, verboseLogs, fetchWholeRepository, useLfs, vcsChangeDetection);
    }

    public BitbucketCloudRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @NotNull String repositorySlug, @Nullable AuthenticationProperties authenticationProperties, @Nullable AuthenticationProperties checkoutAuthenticationProperties, @NotNull String branch, @Nullable ProjectProperties project, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs, VcsChangeDetectionProperties vcsChangeDetection) throws PropertiesValidationException {
        super(name, oid, description, parent, repositoryViewerProperties, project);
        this.repositorySlug = repositorySlug;
        this.authenticationProperties = authenticationProperties;
        this.checkoutAuthenticationProperties = checkoutAuthenticationProperties;
        this.branch = branch;
        this.useShallowClones = useShallowClones;
        this.useRemoteAgentCache = useRemoteAgentCache;
        this.useSubmodules = useSubmodules;
        this.commandTimeout = commandTimeout;
        this.verboseLogs = verboseLogs;
        this.fetchWholeRepository = fetchWholeRepository;
        this.useLfs = useLfs;
        this.vcsChangeDetection = vcsChangeDetection;
        this.validate();
    }

    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE_PROPERTIES;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseRemoteAgentCache() {
        return this.useRemoteAgentCache;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public Duration getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public boolean isFetchWholeRepository() {
        return this.fetchWholeRepository;
    }

    public boolean isUseLfs() {
        return this.useLfs;
    }

    public VcsChangeDetectionProperties getVcsChangeDetection() {
        return this.vcsChangeDetection;
    }

    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Nullable
    public AuthenticationProperties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    @Nullable
    public AuthenticationProperties getCheckoutAuthenticationProperties() {
        return this.checkoutAuthenticationProperties;
    }

    public void validate() {
        super.validate();
        if (!this.hasParent()) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"repositorySlug", (String)this.repositorySlug);
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"branch", (String)this.branch);
        }
        ArrayList errors = new ArrayList();
        ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)VALIDATION_CONTEXT, (String)this.branch).ifPresent(errors::add);
        ImporterUtils.checkNoErrors(errors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BitbucketCloudRepositoryProperties that = (BitbucketCloudRepositoryProperties)((Object)o);
        return this.useShallowClones == that.useShallowClones && this.useRemoteAgentCache == that.useRemoteAgentCache && this.useSubmodules == that.useSubmodules && this.verboseLogs == that.verboseLogs && this.fetchWholeRepository == that.fetchWholeRepository && this.useLfs == that.useLfs && Objects.equals(this.repositorySlug, that.repositorySlug) && Objects.equals(this.authenticationProperties, that.authenticationProperties) && Objects.equals(this.checkoutAuthenticationProperties, that.checkoutAuthenticationProperties) && Objects.equals(this.branch, that.branch) && Objects.equals(this.commandTimeout, that.commandTimeout) && Objects.equals(this.vcsChangeDetection, that.vcsChangeDetection);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.repositorySlug, this.authenticationProperties, this.checkoutAuthenticationProperties, this.branch, this.useShallowClones, this.useRemoteAgentCache, this.useSubmodules, this.commandTimeout, this.verboseLogs, this.fetchWholeRepository, this.useLfs, this.vcsChangeDetection);
    }
}

