/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.git;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.repository.GitAuthenticationEmitter;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.SshPrivateKeyAuthenticationProperties;
import com.atlassian.bamboo.specs.model.repository.git.UserPasswordAuthenticationProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class GitRepositoryProperties
extends VcsRepositoryProperties {
    private static final Set<String> SUPPORTED_SCHEMES = Stream.of("http", "https", "ssh", "file", "git", null).collect(Collectors.toSet());
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2");
    private final String url;
    private String branch;
    @CodeGenerator(value=GitAuthenticationEmitter.class)
    private final AuthenticationProperties authenticationProperties;
    @Setter(value="shallowClonesEnabled")
    private final boolean useShallowClones;
    @Setter(value="remoteAgentCacheEnabled")
    private final boolean useRemoteAgentCache;
    @Setter(value="submodulesEnabled")
    private final boolean useSubmodules;
    private final Duration commandTimeout;
    private final boolean verboseLogs;
    private final boolean fetchWholeRepository;
    @Setter(value="lfsEnabled")
    private final boolean useLfs;
    private VcsChangeDetectionProperties vcsChangeDetection;

    private GitRepositoryProperties() {
        this.url = null;
        this.branch = null;
        this.authenticationProperties = null;
        this.useShallowClones = false;
        this.useRemoteAgentCache = true;
        this.useSubmodules = false;
        this.commandTimeout = Duration.ofMinutes(180L);
        this.verboseLogs = false;
        this.fetchWholeRepository = false;
        this.useLfs = false;
    }

    public GitRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable String url, @Nullable String branch, @Nullable AuthenticationProperties authenticationProperties, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs) throws PropertiesValidationException {
        this(name, oid, description, parent, repositoryViewerProperties, url, branch, null, authenticationProperties, vcsChangeDetection, useShallowClones, useRemoteAgentCache, useSubmodules, commandTimeout, verboseLogs, fetchWholeRepository, useLfs);
    }

    public GitRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties, @Nullable String url, @Nullable String branch, @Nullable ProjectProperties project, @Nullable AuthenticationProperties authenticationProperties, @Nullable VcsChangeDetectionProperties vcsChangeDetection, boolean useShallowClones, boolean useRemoteAgentCache, boolean useSubmodules, @NotNull Duration commandTimeout, boolean verboseLogs, boolean fetchWholeRepository, boolean useLfs) throws PropertiesValidationException {
        super(name, oid, description, parent, repositoryViewerProperties, project);
        this.url = url;
        this.branch = branch;
        this.authenticationProperties = authenticationProperties;
        this.vcsChangeDetection = vcsChangeDetection;
        this.useRemoteAgentCache = useRemoteAgentCache;
        this.useShallowClones = useShallowClones;
        this.useSubmodules = useSubmodules;
        this.commandTimeout = commandTimeout;
        this.verboseLogs = verboseLogs;
        this.fetchWholeRepository = fetchWholeRepository;
        this.useLfs = useLfs;
        if (!this.hasParent() && StringUtils.isBlank((CharSequence)this.branch)) {
            this.branch = "master";
        }
        this.validate();
    }

    @Nullable
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public AuthenticationProperties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    public boolean isUseShallowClones() {
        return this.useShallowClones;
    }

    public boolean isUseRemoteAgentCache() {
        return this.useRemoteAgentCache;
    }

    public boolean isUseSubmodules() {
        return this.useSubmodules;
    }

    public Duration getCommandTimeout() {
        return this.commandTimeout;
    }

    public boolean isVerboseLogs() {
        return this.verboseLogs;
    }

    public boolean isFetchWholeRepository() {
        return this.fetchWholeRepository;
    }

    public boolean isUseLfs() {
        return this.useLfs;
    }

    @Nullable
    public VcsChangeDetectionProperties getVcsChangeDetection() {
        return this.vcsChangeDetection;
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Git repository");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (!this.hasParent()) {
            ImporterUtils.checkRequired((ValidationContext)context.with("URL"), (Object)this.url);
        }
        if (this.url != null && !ValidationUtils.containsBambooVariable((String)this.url)) {
            ValidationUtils.validateNotContainsRelaxedXssRelatedCharacters((ValidationContext)context.with("URL"), (String)this.url).ifPresent(errors::add);
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("URL"), (String)this.url).ifPresent(errors::add);
            this.checkUrl(context.with("URL")).ifPresent(errors::add);
        }
        if (this.branch != null) {
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("Branch name"), (String)this.branch).ifPresent(errors::add);
        }
        if (this.vcsChangeDetection != null && !this.vcsChangeDetection.getConfiguration().isEmpty()) {
            errors.add(new ValidationProblem(context.with("Change detection"), "Git repository cannot have any extra change detection configuration."));
        }
        ImporterUtils.checkNoErrors(errors);
    }

    private Optional<ValidationProblem> checkUrl(@NotNull ValidationContext validationContext) {
        if (this.url == null) {
            return Optional.empty();
        }
        try {
            URI uri = new URI(this.url);
            String scheme = uri.getScheme();
            if (!SUPPORTED_SCHEMES.contains(uri.getScheme())) {
                return Optional.of(new ValidationProblem(validationContext, "scheme '%s' is not supported - supported schemes are: %s", new Object[]{scheme, String.join((CharSequence)", ", SUPPORTED_SCHEMES)}));
            }
            String userInfo = uri.getUserInfo();
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                boolean duplicatePassword;
                int d = userInfo.indexOf(58);
                String user = d < 0 ? userInfo : userInfo.substring(0, d);
                String pass = d < 0 ? null : userInfo.substring(d + 1);
                boolean duplicateUsername = !StringUtils.isBlank((CharSequence)user) && this.authenticationProperties instanceof UserPasswordAuthenticationProperties && StringUtils.isNotBlank((CharSequence)((UserPasswordAuthenticationProperties)this.authenticationProperties).getUsername());
                boolean bl = duplicatePassword = !StringUtils.isBlank((CharSequence)pass) && this.authenticationProperties instanceof UserPasswordAuthenticationProperties && StringUtils.isNotBlank((CharSequence)((UserPasswordAuthenticationProperties)this.authenticationProperties).getPassword());
                if (duplicateUsername) {
                    return Optional.of(new ValidationProblem(validationContext, "Duplicate username" + (duplicatePassword ? " & password" : "")));
                }
                if (duplicatePassword) {
                    return Optional.of(new ValidationProblem(validationContext, "Duplicate password"));
                }
            }
            if (this.authenticationProperties instanceof SshPrivateKeyAuthenticationProperties && ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
                return Optional.of(new ValidationProblem(validationContext, "Ssh authentication not supported with " + uri.getScheme()));
            }
        }
        catch (URISyntaxException e) {
            if (this.url.startsWith("\\\\") || !this.url.contains("://")) {
                return Optional.empty();
            }
            return Optional.of(new ValidationProblem(validationContext, String.format("Malformed URL: %s", this.url)));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitRepositoryProperties that = (GitRepositoryProperties)((Object)o);
        return this.isUseShallowClones() == that.isUseShallowClones() && this.isUseRemoteAgentCache() == that.isUseRemoteAgentCache() && this.isUseSubmodules() == that.isUseSubmodules() && this.isVerboseLogs() == that.isVerboseLogs() && this.isFetchWholeRepository() == that.isFetchWholeRepository() && this.isUseLfs() == that.isUseLfs() && Objects.equals(this.getUrl(), that.getUrl()) && Objects.equals(this.getBranch(), that.getBranch()) && Objects.equals(this.getAuthenticationProperties(), that.getAuthenticationProperties()) && Objects.equals(this.getCommandTimeout(), that.getCommandTimeout()) && Objects.equals(this.getVcsChangeDetection(), that.getVcsChangeDetection());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUrl(), this.getBranch(), this.getAuthenticationProperties(), this.isUseShallowClones(), this.isUseRemoteAgentCache(), this.isUseSubmodules(), this.getCommandTimeout(), this.isVerboseLogs(), this.isFetchWholeRepository(), this.isUseLfs(), this.getVcsChangeDetection());
    }
}

