/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.BaseVcsTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseVcsTask<T extends BaseVcsTask<T, E>, E extends BaseVcsTaskProperties>
extends Task<T, E> {
    protected boolean defaultRepository;
    @Nullable
    protected VcsRepositoryIdentifierProperties repository;
    @Nullable
    protected String workingSubdirectory;

    public T defaultRepository() {
        this.defaultRepository = true;
        this.repository = null;
        return (T)((Object)this);
    }

    public T repository(@NotNull String repositoryName) {
        ImporterUtils.checkNotNull((String)"repositoryName", (Object)repositoryName);
        return this.repository(new VcsRepositoryIdentifier().name(repositoryName));
    }

    public T repository(@NotNull VcsRepositoryIdentifier repositoryIdentifier) {
        ImporterUtils.checkNotNull((String)"repositoryIdentifier", (Object)repositoryIdentifier);
        this.defaultRepository = false;
        this.repository = (VcsRepositoryIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)repositoryIdentifier);
        return (T)((Object)this);
    }

    public T workingSubdirectory(@Nullable String workingSubdirectory) {
        this.workingSubdirectory = workingSubdirectory;
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseVcsTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseVcsTask that = (BaseVcsTask)((Object)o);
        return this.defaultRepository == that.defaultRepository && Objects.equals(this.repository, that.repository) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultRepository, this.repository, this.workingSubdirectory);
    }
}

