/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.task.BaseSshTask;
import com.atlassian.bamboo.specs.model.task.SshTaskProperties;
import com.atlassian.bamboo.specs.util.FileUtils;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshTask
extends BaseSshTask<SshTask, SshTaskProperties> {
    private String command;
    @Nullable
    protected Duration keepAliveInterval;

    public SshTask command(@NotNull String command) {
        ImporterUtils.checkNotEmpty((String)"command", (String)command);
        this.command = command;
        return this;
    }

    public SshTask command(@NotNull Path path) {
        this.command = FileUtils.readFileContent(path, "command body file", "Error when reading ssh command body from path: %s");
        return this;
    }

    public SshTask keepAliveInterval(Duration keepAliveInterval) {
        ImporterUtils.checkNotNull((String)"keep alive interval", (Object)keepAliveInterval);
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    public SshTask keepAliveIntervalInSeconds(int keepAliveIntervalSeconds) {
        return this.keepAliveInterval(Duration.ofSeconds(keepAliveIntervalSeconds));
    }

    private int getKeepAliveIntervalInSec() {
        return this.keepAliveInterval == null ? SshTaskProperties.DEFAULT_KEEP_ALIVE_INTERVAL : (int)this.keepAliveInterval.getSeconds();
    }

    @NotNull
    protected SshTaskProperties build() {
        return new SshTaskProperties(this.description, this.taskEnabled, this.host, this.username, this.authenticationType, this.password, this.key, this.passphrase, this.sharedCredentials, this.hostFingerprint, this.port, this.getKeepAliveIntervalInSec(), this.command, this.requirements, this.conditions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SshTask sshTask = (SshTask)((Object)o);
        return Objects.equals(this.command, sshTask.command) && Objects.equals(this.keepAliveInterval, sshTask.keepAliveInterval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.command, this.keepAliveInterval);
    }
}

