/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.builders.task.DockerBuildImageTask;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.docker.DockerBuildImageTaskProperties;
import org.jetbrains.annotations.NotNull;

public class DockerBuildImageEmitter
extends EntityPropertiesEmitter<DockerBuildImageTaskProperties> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull DockerBuildImageTaskProperties entity) throws CodeGenerationException {
        this.builderClass = DockerBuildImageTask.class;
        this.fieldsToSkip.add("dockerfileContent");
        this.fieldsToSkip.add("dockerfile");
        String dockerBuilderCode = super.emitCode(context, entity);
        try {
            context.incIndentation();
            String string = String.format("%s%s.%s", dockerBuilderCode, context.newLine(), this.emitDockerContentCode(entity));
            return string;
        }
        finally {
            context.decIndentation();
        }
    }

    private String emitDockerContentCode(DockerBuildImageTaskProperties entity) throws CodeGenerationException {
        switch (entity.getDockerfileContent()) {
            case WORKING_DIR: {
                return "dockerfileInWorkingDir()";
            }
            case INLINE: {
                return String.format("dockerfile(\"%s\")", entity.getDockerfile());
            }
        }
        throw new CodeGenerationException("Can't handle: " + entity.getDockerfileContent().name());
    }
}

