/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.trigger;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.CronExpressionClientSideValidator;
import com.atlassian.bamboo.specs.codegen.emitters.trigger.ScheduledTriggerEmitter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CodeGenerator(value=ScheduledTriggerEmitter.class)
@Immutable
public final class ScheduledTriggerProperties
extends TriggerProperties {
    private static final String NAME = "Scheduled";
    public static final String MODULE_KEY = "com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:schedule";
    private static final AtlassianModuleProperties ATLASSIAN_MODULE = (AtlassianModuleProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new AtlassianModule("com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:schedule"));
    private final String cronExpression;
    private final String artifactBranch;
    @SkipCodeGen
    private final Container container;

    private ScheduledTriggerProperties() {
        super(NAME, null, true, Collections.emptySet());
        this.cronExpression = "0 0 0 ? * *";
        this.artifactBranch = null;
        this.container = Container.PLAN;
    }

    public ScheduledTriggerProperties(String description, boolean isEnabled, Set<TriggerConditionProperties> conditions, @NotNull String cronExpression, @Nullable String artifactBranch, @NotNull Container container) throws PropertiesValidationException {
        super(NAME, description, isEnabled, conditions);
        this.cronExpression = cronExpression.trim();
        this.artifactBranch = artifactBranch;
        this.container = container;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getArtifactBranch() {
        return this.artifactBranch;
    }

    public Container getContainer() {
        return this.container;
    }

    public void validate() throws PropertiesValidationException {
        super.validate();
        CronExpressionClientSideValidator.validate((String)this.cronExpression);
    }

    public EnumSet<Applicability> applicableTo() {
        return this.container == Container.PLAN ? EnumSet.of(Applicability.PLANS) : EnumSet.of(Applicability.DEPLOYMENTS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScheduledTriggerProperties that = (ScheduledTriggerProperties)((Object)o);
        return Objects.equals(this.cronExpression, that.cronExpression) && Objects.equals(this.artifactBranch, that.artifactBranch) && this.container == that.container;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.cronExpression, this.artifactBranch, this.container});
    }

    public static enum Container {
        DEPLOYMENT,
        PLAN;

    }
}

