/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.notification;

import com.atlassian.bamboo.specs.api.codegen.annotations.Secret;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class HipChatRecipientProperties
extends NotificationRecipientProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-hipchat:recipient.hipchat");
    @Secret
    private final String apiToken;
    private final String room;
    private final boolean notifyUsers;

    private HipChatRecipientProperties() {
        this.apiToken = null;
        this.room = null;
        this.notifyUsers = false;
    }

    public HipChatRecipientProperties(String apiToken, String room, boolean notifyUsers) {
        this.apiToken = apiToken;
        this.room = room;
        this.notifyUsers = notifyUsers;
        this.validate();
    }

    @NotNull
    public String getApiToken() {
        return this.apiToken;
    }

    @NotNull
    public String getRoom() {
        return this.room;
    }

    public boolean isNotifyUsers() {
        return this.notifyUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HipChatRecipientProperties that = (HipChatRecipientProperties)((Object)o);
        return this.isNotifyUsers() == that.isNotifyUsers() && Objects.equals(this.getApiToken(), that.getApiToken()) && Objects.equals(this.getRoom(), that.getRoom());
    }

    public int hashCode() {
        return Objects.hash(this.getApiToken(), this.getRoom(), this.isNotifyUsers());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"hipChatRecipient");
        ImporterUtils.checkNotBlank((ValidationContext)context, (String)"apiToken", (String)this.apiToken);
        ImporterUtils.checkNotBlank((ValidationContext)context, (String)"room", (String)this.room);
    }
}

