/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.notification;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationTypeProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XFailedChainsNotificationProperties
extends NotificationTypeProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"XFailed Chains Notifications");
    public static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.system.notifications:chainCompleted.XFailedChains");
    private final int numberOfFailures;

    private XFailedChainsNotificationProperties() {
        this.numberOfFailures = 1;
    }

    public XFailedChainsNotificationProperties(int numberOfFailures) {
        this.numberOfFailures = numberOfFailures;
        this.validate();
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public void validate() {
        ImporterUtils.checkPositive((ValidationContext)VALIDATION_CONTEXT, (String)"numberOfFailures", (int)this.numberOfFailures);
    }

    public Set<Applicability> applicableTo() {
        return EnumSet.of(Applicability.PLANS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        XFailedChainsNotificationProperties that = (XFailedChainsNotificationProperties)((Object)o);
        return this.numberOfFailures == that.numberOfFailures;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfFailures);
    }
}

