/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.viewer;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class GenericRepositoryViewerProperties
implements VcsRepositoryViewerProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.repository.atlassian-bamboo-repository-viewers:genericRepositoryViewer");
    private final String viewerUrl;
    private final String repositoryPath;

    private GenericRepositoryViewerProperties() {
        this.viewerUrl = null;
        this.repositoryPath = null;
    }

    public GenericRepositoryViewerProperties(@NotNull String viewerUrl, @Nullable String repositoryPath) throws PropertiesValidationException {
        this.viewerUrl = viewerUrl;
        this.repositoryPath = repositoryPath;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRepositoryViewerProperties)) {
            return false;
        }
        GenericRepositoryViewerProperties that = (GenericRepositoryViewerProperties)o;
        return Objects.equals(this.getViewerUrl(), that.getViewerUrl()) && Objects.equals(this.getRepositoryPath(), that.getRepositoryPath());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public int hashCode() {
        return Objects.hash(this.getViewerUrl(), this.getRepositoryPath());
    }

    @NotNull
    public String getViewerUrl() {
        return this.viewerUrl;
    }

    @Nullable
    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"Generic repository");
        ImporterUtils.checkRequired((ValidationContext)context.with("viewerUrl"), (Object)this.viewerUrl);
    }
}

