/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.credentials;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class UsernamePasswordCredentialsProperties
extends SharedCredentialsProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials");
    private final String username;
    private final String password;

    private UsernamePasswordCredentialsProperties() {
        this.username = null;
        this.password = null;
    }

    public UsernamePasswordCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid, @NotNull String username, @Nullable String password) throws PropertiesValidationException {
        this(name, oid, username, password, null);
    }

    public UsernamePasswordCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid, @NotNull String username, @Nullable String password, @Nullable ProjectProperties project) throws PropertiesValidationException {
        super(name, oid, project);
        this.username = username;
        this.password = password;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsernamePasswordCredentialsProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UsernamePasswordCredentialsProperties that = (UsernamePasswordCredentialsProperties)((Object)o);
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.username, this.password);
    }

    public void validate() {
        super.validate();
    }
}

