/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.trigger;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlansGreenTriggerConditionProperties
extends TriggerConditionProperties {
    private static final String PLUGIN_KEY = "com.atlassian.bamboo.triggercondition.internal:plansGreenCondition";
    private final List<PlanIdentifierProperties> plans;

    private PlansGreenTriggerConditionProperties() {
        this.plans = null;
    }

    public PlansGreenTriggerConditionProperties(@NotNull Set<PlanIdentifierProperties> plans) {
        this.plans = Collections.unmodifiableList(new ArrayList<PlanIdentifierProperties>(plans));
        this.validate();
    }

    public AtlassianModuleProperties getAtlassianPlugin() {
        return new AtlassianModuleProperties(PLUGIN_KEY);
    }

    public List<PlanIdentifierProperties> getPlans() {
        return this.plans;
    }

    public void validate() {
        super.validate();
        if (this.plans.isEmpty()) {
            throw new PropertiesValidationException("Plans should be not empty");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PlansGreenTriggerConditionProperties that = (PlansGreenTriggerConditionProperties)((Object)o);
        return Objects.equals(this.plans, that.plans);
    }

    public int hashCode() {
        return Objects.hash(PLUGIN_KEY, this.plans);
    }
}

