/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.permission;

import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.permission.AnonymousUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.LoggedInUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionPropertiesEmitter
extends EntityPropertiesEmitter<PermissionsProperties> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull PermissionsProperties permissionProperties) throws CodeGenerationException {
        ArrayList<String> codeLines = new ArrayList<String>();
        this.builderClass = Permissions.class;
        this.fieldsToSkip.add("userPermissions");
        this.fieldsToSkip.add("groupPermissions");
        this.fieldsToSkip.add("loggedInUserPermissions");
        this.fieldsToSkip.add("anonymousUserPermissions");
        try {
            context.incIndentation();
            codeLines.add(super.emitCode(context, permissionProperties));
            permissionProperties.getUserPermissions().forEach(userPermissionProperties -> codeLines.add(this.userPermissions(context, (UserPermissionProperties)userPermissionProperties)));
            permissionProperties.getGroupPermissions().forEach(groupPermissionProperties -> codeLines.add(this.groupPermissions(context, (GroupPermissionProperties)groupPermissionProperties)));
            codeLines.add(this.loggedInUserPermission(context, permissionProperties.getLoggedInUserPermissions()));
            codeLines.add(this.anonymousPermissions(context, permissionProperties.getAnonymousUserPermissions()));
            String string = StringUtils.join((Iterable)codeLines.stream().filter(Objects::nonNull).collect(Collectors.toList()), (String)context.newLine());
            return string;
        }
        finally {
            context.decIndentation();
        }
    }

    @Nullable
    private String userPermissions(@NotNull CodeGenerationContext context, UserPermissionProperties userPermission) {
        if (userPermission.getPermissionTypes().isEmpty()) {
            return null;
        }
        return ".userPermissions(\"" + userPermission.getUsername() + "\", " + this.permissions(context, userPermission.getPermissionTypes()) + ")";
    }

    @Nullable
    private String groupPermissions(@NotNull CodeGenerationContext context, GroupPermissionProperties groupPermission) {
        if (groupPermission.getPermissionTypes().isEmpty()) {
            return null;
        }
        return ".groupPermissions(\"" + groupPermission.getGroup() + "\", " + this.permissions(context, groupPermission.getPermissionTypes()) + ")";
    }

    @Nullable
    private String loggedInUserPermission(@NotNull CodeGenerationContext context, LoggedInUserPermissionsProperties loggedInUserPermission) {
        if (loggedInUserPermission.getPermissionTypes().isEmpty()) {
            return null;
        }
        return ".loggedInUserPermissions(" + this.permissions(context, loggedInUserPermission.getPermissionTypes()) + ")";
    }

    @Nullable
    private String anonymousPermissions(@NotNull CodeGenerationContext context, AnonymousUserPermissionsProperties anonymousUserPermission) throws CodeGenerationException {
        if (anonymousUserPermission.getPermissionTypes().isEmpty()) {
            return null;
        }
        if (anonymousUserPermission.getPermissionTypes().size() > 1 || anonymousUserPermission.getPermissionTypes().get(0) != PermissionType.VIEW) {
            throw new CodeGenerationException(String.format("Could not generate code for anonymous permission(s): %s. The only supported permission for anonymous user is: %s", anonymousUserPermission.getPermissionTypes(), PermissionType.VIEW));
        }
        return ".anonymousUserPermissionView()";
    }

    private String permissions(@NotNull CodeGenerationContext context, Collection<PermissionType> permissions) {
        context.importClassName(PermissionType.class);
        String prefix = PermissionType.class.getSimpleName() + ".";
        return permissions.stream().map(Object::toString).collect(Collectors.joining(", " + prefix, prefix, ""));
    }
}

