/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.validators.common;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.validator.routines.InetAddressValidator;

public final class InternetAddressValidator {
    private InternetAddressValidator() {
    }

    public static void checkComaSeparatedIpAddressesOrCidrs(String ipAddressesOrCidrs) throws PropertiesValidationException {
        for (String ipAddressOrCidr : ipAddressesOrCidrs.split("\\s*,\\s*")) {
            if (!StringUtils.isNotEmpty((CharSequence)ipAddressOrCidr) || InternetAddressValidator.isIpAddressOrCidrValid(ipAddressOrCidr)) continue;
            throw new PropertiesValidationException(String.format("Invalid coma separated IPs/CIDRs: %s, error when validating %s", ipAddressesOrCidrs, ipAddressOrCidr));
        }
    }

    public static void checkIpAddressOrCidr(String ipAddressOrCidr) throws PropertiesValidationException {
        if (!InternetAddressValidator.isIpAddressOrCidrValid(ipAddressOrCidr)) {
            throw new PropertiesValidationException(String.format("Invalid IP/CIDR: %s", ipAddressOrCidr));
        }
    }

    private static boolean isIpAddressOrCidrValid(String ipAddressOrCidr) {
        String ipAddress = StringUtils.substringBefore((String)ipAddressOrCidr, (String)"/");
        String prefixLen = StringUtils.substringAfter((String)ipAddressOrCidr, (String)"/");
        if (!prefixLen.isEmpty() && !NumberUtils.isDigits((String)prefixLen)) {
            return false;
        }
        return InetAddressValidator.getInstance().isValid(ipAddress);
    }
}

