/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.RestHelper;
import com.atlassian.bamboo.specs.util.RestTaskFactory;
import com.atlassian.bamboo.specs.util.RestTaskResult;
import java.net.URI;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;

public final class SendQueue {
    private static final SynchronousQueue<RestTaskFactory.RestTask> TASK_QUEUE = new SynchronousQueue();
    private static final SynchronousQueue<RestTaskResult> RESULT_QUEUE = new SynchronousQueue();
    private static final RestHelper REST_HELPER = new RestHelper();

    private SendQueue() {
    }

    private static RestTaskFactory.RestTask take(BlockingQueue<RestTaskFactory.RestTask> queue) {
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static RestTaskResult put(RestTaskFactory.RestTask restTask) {
        try {
            TASK_QUEUE.put(restTask);
            return RESULT_QUEUE.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void put(RestTaskResult result) {
        try {
            RESULT_QUEUE.put(result);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Thread thread = new Thread("Entity REST sender"){

            @Override
            public void run() {
                while (true) {
                    RestTaskFactory.RestTask restTask = SendQueue.take(TASK_QUEUE);
                    try {
                        URI restEndpointUri = restTask.getRestEndpointUri();
                        String response = REST_HELPER.post(restEndpointUri, restTask.getAuthenticationProvider(), restTask.getYamlString());
                        SendQueue.put(RestTaskResult.forResult(response));
                        continue;
                    }
                    catch (Exception e) {
                        SendQueue.put(RestTaskResult.forException(e));
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

