package com.atlassian.bamboo.specs.util;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Holds the Bamboo Specs version. Reads the autogenerated properties file to keep Specs version in sync with Maven project.
 */
public final class BambooSpecVersion {
    private static final Logger log = Logger.getLogger(RestHelper.class);

    private static final String UNKNOWN = "UNKNOWN";
    private static final String BAMBOO_SPECS_VERSION_PROPERTY = "bamboo-specs.version";

    private static final String MODEL_VERSION;

    static {
        final String modelVersion;
        try (InputStream inputStream = BambooSpecVersion.class.getClassLoader().getResourceAsStream("bamboo-specs.properties")) {
            if (inputStream == null) {
                throw new IOException("Can't find bamboo-specs.proprties");
            }
            Properties properties = new Properties();
            properties.load(inputStream);

            String version = properties.getProperty(BAMBOO_SPECS_VERSION_PROPERTY);
            modelVersion = StringUtils.isNotBlank(version) ? version : UNKNOWN;
        } catch (Exception e) {
            String errorMessage = "Couldn't read the Bamboo Specs version";
            if (e.getMessage() != null) {
                errorMessage += ", because: " + e.getMessage();
            }
            log.info(errorMessage);
            throw new RuntimeException(e);
        }
        MODEL_VERSION = modelVersion;
    }

    private BambooSpecVersion() {

    }

    @NotNull
    public static String getModelVersion() {
        return MODEL_VERSION;
    }
}
