/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.CommandTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandTask
extends Task<CommandTask, CommandTaskProperties> {
    private String executable;
    @Nullable
    private String argument;
    @Nullable
    private String environmentVariables;
    @Nullable
    private String workingSubdirectory;

    public CommandTask executable(@NotNull String executable) {
        ImporterUtils.checkNotEmpty((String)"executable", (String)executable);
        this.executable = executable;
        return this;
    }

    public CommandTask argument(@NotNull String argument) {
        ImporterUtils.checkNotEmpty((String)"argument", (String)argument);
        this.argument = argument;
        return this;
    }

    public CommandTask environmentVariables(@NotNull String environmentVariables) {
        ImporterUtils.checkNotEmpty((String)"environment variables", (String)environmentVariables);
        this.environmentVariables = environmentVariables;
        return this;
    }

    public CommandTask workingSubdirectory(@NotNull String workingSubdirectory) {
        ImporterUtils.checkNotEmpty((String)"working subdirectory", (String)workingSubdirectory);
        this.workingSubdirectory = workingSubdirectory;
        return this;
    }

    @NotNull
    protected CommandTaskProperties build() {
        return new CommandTaskProperties(this.description, this.taskEnabled, this.executable, this.argument, this.environmentVariables, this.workingSubdirectory, this.requirements, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommandTask that = (CommandTask)((Object)o);
        return Objects.equals(this.executable, that.executable) && Objects.equals(this.argument, that.argument) && Objects.equals(this.environmentVariables, that.environmentVariables) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.executable, this.argument, this.environmentVariables, this.workingSubdirectory);
    }
}

