package com.atlassian.bamboo.specs.builders.repository.bitbucket.cloud;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.model.repository.bitbucket.cloud.EmailApiTokenAuthenticationProperties;
import org.jetbrains.annotations.Nullable;

import static com.atlassian.bamboo.specs.api.validators.common.ImporterUtils.checkNotNull;

/**
 * Email/API token authentication method for bitbucket cloud repository.
 */
public class EmailApiTokenAuthentication extends EntityPropertiesBuilder<EmailApiTokenAuthenticationProperties> {
    private String email;
    private String apiToken;

    /**
     * Specifies new email/API token credentials for Bitbucket Cloud repository.
     *
     * @param email user email
     */
    public EmailApiTokenAuthentication(String email) {
        checkNotNull("username", email);

        this.email = email;
    }

    public EmailApiTokenAuthentication() {}

    /**
     * Sets Bitbucket Cloud email.
     */
    public EmailApiTokenAuthentication email(String email) {
        checkNotNull("email", email);

        this.email = email;
        return this;
    }

    /**
     * Sets the API token to an account. The API token can be both in Bamboo encrypted and plain form.
     *
     * @see <a href="https://support.atlassian.com/bitbucket-cloud/docs/using-api-tokens/">Using API tokens in Bitbucket Cloud</a>
     * @see <a href="https://confluence.atlassian.com/bamboo/bamboo-specs-encryption-970268127.html">Encryption in Bamboo Specs</a>
     */
    public EmailApiTokenAuthentication apiToken(@Nullable String apiToken) {
        this.apiToken = apiToken;
        return this;
    }

    protected EmailApiTokenAuthenticationProperties build() {
        return new EmailApiTokenAuthenticationProperties(email, apiToken);
    }
}
