/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.BambooSpecsPublishingException;
import com.atlassian.bamboo.specs.api.rsbs.RunnerSettings;
import com.atlassian.bamboo.specs.exceptions.BambooSpecsRestRequestException;
import com.atlassian.bamboo.specs.util.AuthenticationProvider;
import com.atlassian.bamboo.specs.util.BambooSpecSerializer;
import com.atlassian.bamboo.specs.util.FileAuthenticationProvider;
import com.atlassian.bamboo.specs.util.LogUtils;
import com.atlassian.bamboo.specs.util.Logger;
import com.atlassian.bamboo.specs.util.RestTaskFactory;
import com.atlassian.bamboo.specs.util.RestTaskResult;
import com.atlassian.bamboo.specs.util.SendQueue;
import com.atlassian.bamboo.specs.util.SimpleUserPasswordCredentials;
import com.atlassian.bamboo.specs.util.YamlFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.UnsupportedSchemeException;
import org.jetbrains.annotations.NotNull;

public class BambooServer {
    private static final Logger log = Logger.getLogger(BambooServer.class);
    private final URI baseUrl;
    private final AuthenticationProvider authenticationProvider;

    public BambooServer(@NotNull String baseUrl) {
        this(baseUrl, RunnerSettings.isRestEnabled() ? new FileAuthenticationProvider() : new SimpleUserPasswordCredentials("none", "none"));
    }

    public BambooServer(@NotNull String baseUrl, @NotNull AuthenticationProvider authenticationProvider) {
        this.baseUrl = URI.create(baseUrl + '/');
        this.authenticationProvider = authenticationProvider;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public Object publish(@NotNull RootEntityPropertiesBuilder entityProperties) {
        log.info("Publishing " + entityProperties.humanReadableId(), new Object[0]);
        String yaml = BambooSpecSerializer.dump(entityProperties);
        Path yamlDir = RunnerSettings.getYamlDir();
        if (yamlDir != null) {
            Path subDir = yamlDir.resolve(BambooServer.getSubdirectoryName(entityProperties));
            try {
                Files.createDirectories(subDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path outputPath = subDir.resolve(YamlFile.getFileName(entityProperties, yaml));
            log.info("Writing specs into " + outputPath, new Object[0]);
            try (BufferedWriter bw = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
                bw.write(yaml);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!RunnerSettings.isRestEnabled()) {
            return new Object();
        }
        RestTaskFactory.RestTask restTask = RestTaskFactory.create(this.getBaseUrl(), this.authenticationProvider, entityProperties, yaml);
        RestTaskResult result = SendQueue.put(restTask);
        if (result.getException() != null) {
            BambooSpecsPublishingException exception = this.translateException(entityProperties, result.getException());
            log.info(exception.getMessage(), new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)exception.getDebugMessage())) {
                LogUtils.hintLogLevel(log, Logger.LogLevel.DEBUG);
                log.debug(exception.getDebugMessage(), new Object[0]);
            }
            throw exception;
        }
        log.info("Successfully published " + entityProperties.humanReadableId(), new Object[0]);
        return result.getResult();
    }

    private static String getSubdirectoryName(@NotNull RootEntityPropertiesBuilder entityProperties) {
        return entityProperties.humanReadableType().replaceAll("\\W", "-");
    }

    @NotNull
    private BambooSpecsPublishingException translateException(@NotNull RootEntityPropertiesBuilder entityProperties, @NotNull Exception exception) {
        if (exception instanceof UnknownHostException) {
            return new BambooSpecsPublishingException(entityProperties, BambooSpecsPublishingException.ErrorType.UNKNOWN_HOST, String.format("Could not reach Bamboo at %s - please make sure the URL is correct and that there are no network problems", this.getBaseUrl()), null, (Throwable)exception);
        }
        if (exception instanceof ConnectException) {
            return new BambooSpecsPublishingException(entityProperties, BambooSpecsPublishingException.ErrorType.CONNECTION_ERROR, String.format("Could not connect to Bamboo at %s - please make sure the URL is correct and that Bamboo is running", this.getBaseUrl()), null, (Throwable)exception);
        }
        if (exception instanceof ClientProtocolException || exception instanceof UnsupportedSchemeException) {
            return new BambooSpecsPublishingException(entityProperties, BambooSpecsPublishingException.ErrorType.PROTOCOL_ERROR, String.format("Could not connect to Bamboo at %s - please make sure the URL is valid and that it uses HTTP(S) protocol", this.getBaseUrl()), null, (Throwable)exception);
        }
        if (exception instanceof BambooSpecsRestRequestException) {
            return this.translateRestException(entityProperties, (BambooSpecsRestRequestException)exception);
        }
        return new BambooSpecsPublishingException(entityProperties, null, null, null, (Throwable)exception);
    }

    @NotNull
    private BambooSpecsPublishingException translateRestException(@NotNull RootEntityPropertiesBuilder entityProperties, @NotNull BambooSpecsRestRequestException restException) {
        switch (restException.getStatusCode()) {
            case 401: {
                String errorMessage = String.format("Could not authenticate user in Bamboo at %s - please make sure the credentials are correct: %s", this.getBaseUrl(), this.authenticationProvider);
                return new BambooSpecsPublishingException(entityProperties, BambooSpecsPublishingException.ErrorType.UNAUTHORIZED, errorMessage, restException.getResponseEntity(), (Throwable)restException);
            }
        }
        String errorMessage = StringUtils.defaultString((String)restException.getMessage(), (String)String.format("Unknown response from Bamboo at %s (HTTP %d)", this.getBaseUrl(), restException.getStatusCode()));
        return new BambooSpecsPublishingException(entityProperties, null, errorMessage, restException.getResponseEntity(), (Throwable)restException);
    }
}

